/*
 * Decompiled with CFR 0.152.
 */
package com.worldline.connect.sdk.java.communication;

import com.worldline.connect.sdk.java.communication.MetadataProvider;
import com.worldline.connect.sdk.java.communication.RequestHeader;
import com.worldline.connect.sdk.java.domain.ShoppingCartExtension;
import java.util.ArrayList;
import java.util.List;

public class MetadataProviderBuilder {
    final String integrator;
    ShoppingCartExtension shoppingCartExtension;
    final List<RequestHeader> additionalRequestHeaders = new ArrayList<RequestHeader>();

    public MetadataProviderBuilder(String integrator) {
        if (integrator == null || integrator.trim().isEmpty()) {
            throw new IllegalArgumentException("integrator is required");
        }
        this.integrator = integrator;
    }

    public MetadataProviderBuilder withShoppingCartExtension(ShoppingCartExtension shoppingCartExtension) {
        this.shoppingCartExtension = shoppingCartExtension;
        return this;
    }

    public MetadataProviderBuilder withAdditionalRequestHeader(RequestHeader additionalRequestHeader) {
        MetadataProvider.validateAdditionalRequestHeader(additionalRequestHeader);
        this.additionalRequestHeaders.add(additionalRequestHeader);
        return this;
    }

    public MetadataProvider build() {
        return new MetadataProvider(this);
    }
}

