/*
 * Decompiled with CFR 0.152.
 */
package com.worldline.connect.sdk.java.communication;

import java.util.List;
import java.util.regex.Pattern;

public class RequestHeader {
    private static final Pattern WHITE_SPACE_NORMALIZER = Pattern.compile("\r?\n[\\s&&[^\r\n]]*");
    private final String name;
    private final String value;

    public RequestHeader(String name, String value) {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("name is required");
        }
        this.name = name;
        this.value = RequestHeader.normalizeValue(value);
    }

    static String normalizeValue(String value) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        return WHITE_SPACE_NORMALIZER.matcher(value).replaceAll(" ").trim();
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getName() + ":" + this.getValue();
    }

    public static RequestHeader getHeader(List<RequestHeader> headers, String headerName) {
        for (RequestHeader header : headers) {
            if (!header.getName().equalsIgnoreCase(headerName)) continue;
            return header;
        }
        return null;
    }

    public static String getHeaderValue(List<RequestHeader> headers, String headerName) {
        RequestHeader header = RequestHeader.getHeader(headers, headerName);
        return header != null ? header.getValue() : null;
    }
}

