/*
 * Decompiled with CFR 0.152.
 */
package com.worldline.connect.sdk.java.domain;

import java.io.InputStream;

public class UploadableFile {
    private final String fileName;
    private final InputStream content;
    private final String contentType;
    private final long contentLength;

    public UploadableFile(String fileName, InputStream content, String contentType) {
        this(fileName, content, contentType, -1L);
    }

    public UploadableFile(String fileName, InputStream content, String contentType, long contentLength) {
        if (fileName == null || fileName.trim().isEmpty()) {
            throw new IllegalArgumentException("fileName is required");
        }
        if (content == null) {
            throw new IllegalArgumentException("content is required");
        }
        if (contentType == null || contentType.trim().isEmpty()) {
            throw new IllegalArgumentException("contentType is required");
        }
        this.fileName = fileName;
        this.content = content;
        this.contentType = contentType;
        this.contentLength = Math.max(contentLength, -1L);
    }

    public String getFileName() {
        return this.fileName;
    }

    public InputStream getContent() {
        return this.content;
    }

    public String getContentType() {
        return this.contentType;
    }

    public long getContentLength() {
        return this.contentLength;
    }
}

