/*
 * Decompiled with CFR 0.152.
 */
package com.worldline.connect.sdk.java.json;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.worldline.connect.sdk.java.json.Marshaller;
import com.worldline.connect.sdk.java.json.MarshallerSyntaxException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class DefaultMarshaller
implements Marshaller {
    private static final Gson GSON = new Gson();
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    public static final DefaultMarshaller INSTANCE = new DefaultMarshaller();

    protected DefaultMarshaller() {
    }

    @Override
    public String marshal(Object requestObject) {
        return GSON.toJson(requestObject);
    }

    @Override
    public <T> T unmarshal(String responseJson, Class<T> type) {
        try {
            return (T)GSON.fromJson(responseJson, type);
        }
        catch (JsonSyntaxException e) {
            throw new MarshallerSyntaxException(e);
        }
    }

    @Override
    public <T> T unmarshal(InputStream responseJson, Class<T> type) {
        try {
            return (T)GSON.fromJson((Reader)new InputStreamReader(responseJson, CHARSET), type);
        }
        catch (JsonSyntaxException e) {
            throw new MarshallerSyntaxException(e);
        }
    }
}

