/*
 * Decompiled with CFR 0.152.
 */
package com.worldline.connect.sdk.java.logging;

import com.worldline.connect.sdk.java.logging.ObfuscationRule;
import com.worldline.connect.sdk.java.logging.ValueObfuscator;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class BodyObfuscator {
    private static final BodyObfuscator DEFAULT_OBFUSCATOR = BodyObfuscator.custom().build();
    private final Map<String, ObfuscationRule> obfuscationRules;
    private final Pattern propertyPattern;

    private BodyObfuscator(Map<String, ObfuscationRule> obfuscationRules) {
        this.obfuscationRules = Collections.unmodifiableMap(new LinkedHashMap<String, ObfuscationRule>(obfuscationRules));
        this.propertyPattern = BodyObfuscator.buildPropertyPattern(obfuscationRules.keySet());
    }

    private static Pattern buildPropertyPattern(Set<String> propertyNames) {
        if (propertyNames.isEmpty()) {
            return Pattern.compile("$^");
        }
        Iterator<String> iterator = propertyNames.iterator();
        StringBuilder regex = new StringBuilder();
        regex.append("([\"'])(");
        regex.append(Pattern.quote(iterator.next()));
        while (iterator.hasNext()) {
            regex.append('|').append(Pattern.quote(iterator.next()));
        }
        regex.append(")\\1\\s*:\\s*(?:([\"'])(.*?)(?<!\\\\)\\3|([^\"'\\s\\[\\{][\\S&&[^,]]*))");
        int flags = 32;
        return Pattern.compile(regex.toString(), 32);
    }

    private String obfuscateValue(String propertyName, String value) {
        ObfuscationRule obfuscationRule = this.obfuscationRules.get(propertyName);
        return obfuscationRule != null ? obfuscationRule.obfuscateValue(value) : value;
    }

    public String obfuscateBody(CharSequence body) {
        if (body == null) {
            return null;
        }
        if (body.length() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(body.length());
        int index = 0;
        Matcher matcher = this.propertyPattern.matcher(body);
        while (matcher.find()) {
            String propertyName = matcher.group(2);
            String value = matcher.group(4);
            int valueStart = matcher.start(4);
            int valueEnd = matcher.end(4);
            if (value == null) {
                value = matcher.group(5);
                valueStart = matcher.start(5);
                valueEnd = matcher.end(5);
            }
            String obfuscatedValue = this.obfuscateValue(propertyName, value);
            sb.append(body, index, valueStart);
            sb.append(obfuscatedValue);
            index = valueEnd;
        }
        sb.append(body, index, body.length());
        return sb.toString();
    }

    public String obfuscateBody(InputStream bodyStream, Charset charset) throws IOException {
        return this.obfuscateBody(new InputStreamReader(bodyStream, charset));
    }

    public String obfuscateBody(Reader bodyStream) throws IOException {
        int len;
        StringBuilder body = new StringBuilder();
        char[] buffer = new char[4096];
        while ((len = bodyStream.read(buffer)) != -1) {
            body.append(buffer, 0, len);
        }
        return this.obfuscateBody(body);
    }

    public static Builder custom() {
        return new Builder().obfuscateAllButLast(4, "cardNumber").obfuscateAllButLast(2, "expiryDate").obfuscateAll("cvv").obfuscateAllButLast(4, "iban").obfuscateAllButLast(4, "accountNumber").obfuscateAllButLast(4, "reformattedAccountNumber").obfuscateAllButFirst(6, "bin").obfuscateAll("value").obfuscateWithFixedLength(8, "keyId").obfuscateWithFixedLength(8, "secretKey").obfuscateWithFixedLength(8, "publicKey").obfuscateWithFixedLength(8, "userAuthenticationToken").obfuscateWithFixedLength(8, "encryptedPayload").obfuscateWithFixedLength(8, "decryptedPayload").obfuscateWithFixedLength(8, "encryptedCustomerInput");
    }

    public static BodyObfuscator defaultObfuscator() {
        return DEFAULT_OBFUSCATOR;
    }

    public static final class Builder {
        private final Map<String, ObfuscationRule> obfuscationRules = new LinkedHashMap<String, ObfuscationRule>();

        private Builder() {
        }

        public Builder obfuscateAll(String propertyName) {
            this.obfuscationRules.put(propertyName, ValueObfuscator.ALL);
            return this;
        }

        public Builder obfuscateWithFixedLength(int fixedLength, String propertyName) {
            this.obfuscationRules.put(propertyName, ValueObfuscator.fixedLength(fixedLength));
            return this;
        }

        public Builder obfuscateAllButFirst(int count, String propertyName) {
            this.obfuscationRules.put(propertyName, ValueObfuscator.keepStartCount(count));
            return this;
        }

        public Builder obfuscateAllButLast(int count, String propertyName) {
            this.obfuscationRules.put(propertyName, ValueObfuscator.keepEndCount(count));
            return this;
        }

        public Builder obfuscateCustom(String propertyName, ObfuscationRule obfuscationRule) {
            if (obfuscationRule == null) {
                throw new IllegalArgumentException("obfuscationRule is required");
            }
            this.obfuscationRules.put(propertyName, obfuscationRule);
            return this;
        }

        public BodyObfuscator build() {
            return new BodyObfuscator(this.obfuscationRules);
        }
    }
}

