/*
 * Decompiled with CFR 0.152.
 */
package com.worldline.connect.sdk.java.logging;

import com.worldline.connect.sdk.java.logging.BodyObfuscator;
import com.worldline.connect.sdk.java.logging.HeaderObfuscator;
import com.worldline.connect.sdk.java.logging.LogMessageBuilder;

public class ResponseLogMessageBuilder
extends LogMessageBuilder {
    private final int statusCode;
    private final long duration;

    public ResponseLogMessageBuilder(String requestId, int statusCode, BodyObfuscator bodyObfuscator, HeaderObfuscator headerObfuscator) {
        this(requestId, statusCode, -1L, bodyObfuscator, headerObfuscator);
    }

    public ResponseLogMessageBuilder(String requestId, int statusCode, long duration, BodyObfuscator bodyObfuscator, HeaderObfuscator headerObfuscator) {
        super(requestId, bodyObfuscator, headerObfuscator);
        this.statusCode = statusCode;
        this.duration = duration;
    }

    @Override
    public String getMessage() {
        if (this.duration < 0L) {
            String messageTemplate = "Incoming response (requestId='%s'):%n  status-code:  '%d'%n  headers:      '%s'%n  content-type: '%s'%n  body:         '%s'";
            return String.format("Incoming response (requestId='%s'):%n  status-code:  '%d'%n  headers:      '%s'%n  content-type: '%s'%n  body:         '%s'", this.requestId(), this.statusCode, this.headers(), this.emptyIfNull(this.contentType()), this.emptyIfNull(this.body()));
        }
        String messageTemplate = "Incoming response (requestId='%s', %d ms):%n  status-code:  '%d'%n  headers:      '%s'%n  content-type: '%s'%n  body:         '%s'";
        return String.format("Incoming response (requestId='%s', %d ms):%n  status-code:  '%d'%n  headers:      '%s'%n  content-type: '%s'%n  body:         '%s'", this.requestId(), this.duration, this.statusCode, this.headers(), this.emptyIfNull(this.contentType()), this.emptyIfNull(this.body()));
    }
}

