/*
 * Decompiled with CFR 0.152.
 */
package com.worldline.connect.sdk.java.logging;

import com.worldline.connect.sdk.java.logging.ObfuscationRule;
import java.util.Arrays;

final class ValueObfuscator
implements ObfuscationRule {
    static final ValueObfuscator ALL = new ValueObfuscator(0, 0, 0);
    private final char maskCharacter = (char)42;
    private final int fixedLength;
    private final int keepStartCount;
    private final int keepEndCount;

    private ValueObfuscator(int fixedLength, int keepStartCount, int keepEndCount) {
        this.fixedLength = fixedLength;
        this.keepStartCount = keepStartCount;
        this.keepEndCount = keepEndCount;
    }

    static ValueObfuscator fixedLength(int fixedLength) {
        return new ValueObfuscator(fixedLength, 0, 0);
    }

    static ValueObfuscator keepStartCount(int count) {
        return new ValueObfuscator(0, count, 0);
    }

    static ValueObfuscator keepEndCount(int count) {
        return new ValueObfuscator(0, 0, count);
    }

    @Override
    public String obfuscateValue(String value) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        if (this.fixedLength > 0) {
            return this.repeatMask(this.fixedLength);
        }
        if (this.keepStartCount == 0 && this.keepEndCount == 0) {
            return this.repeatMask(value.length());
        }
        if (value.length() < this.keepStartCount + this.keepEndCount) {
            return value;
        }
        char[] chars = value.toCharArray();
        Arrays.fill(chars, this.keepStartCount, value.length() - this.keepEndCount, this.maskCharacter);
        return new String(chars);
    }

    private String repeatMask(int count) {
        char[] chars = new char[count];
        Arrays.fill(chars, this.maskCharacter);
        return new String(chars);
    }
}

