/*
 * Decompiled with CFR 0.152.
 */
package com.worldline.connect.sdk.java.v1;

import com.worldline.connect.sdk.java.v1.DeclinedTransactionException;
import com.worldline.connect.sdk.java.v1.domain.CreatePaymentResult;
import com.worldline.connect.sdk.java.v1.domain.PaymentErrorResponse;
import java.util.Optional;

public class DeclinedPaymentException
extends DeclinedTransactionException {
    private final PaymentErrorResponse response;

    public DeclinedPaymentException(int statusCode, String responseBody, PaymentErrorResponse response) {
        super(DeclinedPaymentException.buildMessage(response), statusCode, responseBody, response != null ? response.getErrorId() : null, response != null ? response.getErrors() : null);
        this.response = response;
    }

    private static String buildMessage(PaymentErrorResponse response) {
        return Optional.ofNullable(response).map(PaymentErrorResponse::getPaymentResult).map(CreatePaymentResult::getPayment).map(payment -> String.format("declined payment '%s' with status '%s'", payment.getId(), payment.getStatus())).orElse("the Worldline Global Collect platform returned a declined payment response");
    }

    public CreatePaymentResult getCreatePaymentResult() {
        return this.response == null ? null : this.response.getPaymentResult();
    }
}

