/*
 * Decompiled with CFR 0.152.
 */
package com.worldline.connect.sdk.java.v1;

import com.worldline.connect.sdk.java.v1.DeclinedTransactionException;
import com.worldline.connect.sdk.java.v1.domain.PayoutErrorResponse;
import com.worldline.connect.sdk.java.v1.domain.PayoutResult;
import java.util.Optional;

public class DeclinedPayoutException
extends DeclinedTransactionException {
    private final PayoutErrorResponse response;

    public DeclinedPayoutException(int statusCode, String responseBody, PayoutErrorResponse response) {
        super(DeclinedPayoutException.buildMessage(response), statusCode, responseBody, response != null ? response.getErrorId() : null, response != null ? response.getErrors() : null);
        this.response = response;
    }

    private static String buildMessage(PayoutErrorResponse response) {
        return Optional.ofNullable(response).map(PayoutErrorResponse::getPayoutResult).map(payoutResult -> String.format("declined payout '%s' with status '%s'", payoutResult.getId(), payoutResult.getStatus())).orElse("the Worldline Global Collect platform returned a declined payout response");
    }

    public PayoutResult getPayoutResult() {
        return this.response == null ? null : this.response.getPayoutResult();
    }
}

