/*
 * Decompiled with CFR 0.152.
 */
package com.worldline.connect.sdk.java.v1;

import com.worldline.connect.sdk.java.v1.DeclinedTransactionException;
import com.worldline.connect.sdk.java.v1.domain.RefundErrorResponse;
import com.worldline.connect.sdk.java.v1.domain.RefundResult;
import java.util.Optional;

public class DeclinedRefundException
extends DeclinedTransactionException {
    private final RefundErrorResponse response;

    public DeclinedRefundException(int statusCode, String responseBody, RefundErrorResponse response) {
        super(DeclinedRefundException.buildMessage(response), statusCode, responseBody, response != null ? response.getErrorId() : null, response != null ? response.getErrors() : null);
        this.response = response;
    }

    private static String buildMessage(RefundErrorResponse response) {
        return Optional.ofNullable(response).map(RefundErrorResponse::getRefundResult).map(refundResult -> String.format("declined refund '%s' with status '%s'", refundResult.getId(), refundResult.getStatus())).orElse("the Worldline Global Collect platform returned a declined refund response");
    }

    public RefundResult getRefundResult() {
        return this.response == null ? null : this.response.getRefundResult();
    }
}

