/*
 * Decompiled with CFR 0.152.
 */
package com.worldline.connect.sdk.java.v1.merchant.captures;

import com.worldline.connect.sdk.java.ApiResource;
import com.worldline.connect.sdk.java.CallContext;
import com.worldline.connect.sdk.java.communication.ResponseException;
import com.worldline.connect.sdk.java.v1.ExceptionFactory;
import com.worldline.connect.sdk.java.v1.domain.CaptureResponse;
import com.worldline.connect.sdk.java.v1.domain.ErrorResponse;
import com.worldline.connect.sdk.java.v1.domain.RefundErrorResponse;
import com.worldline.connect.sdk.java.v1.domain.RefundRequest;
import com.worldline.connect.sdk.java.v1.domain.RefundResponse;
import java.util.Map;
import java.util.TreeMap;

public class CapturesClient
extends ApiResource {
    private static final ExceptionFactory EXCEPTION_FACTORY = new ExceptionFactory();

    public CapturesClient(ApiResource parent, Map<String, String> pathContext) {
        super(parent, pathContext);
    }

    public CaptureResponse get(String captureId) {
        return this.get(captureId, null);
    }

    public CaptureResponse get(String captureId, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("captureId", captureId);
        String uri = this.instantiateUri("/v1/{merchantId}/captures/{captureId}", pathContext);
        try {
            return this.communicator.get(uri, this.getClientHeaders(), null, CaptureResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    public RefundResponse refund(String captureId, RefundRequest body) {
        return this.refund(captureId, body, null);
    }

    public RefundResponse refund(String captureId, RefundRequest body, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("captureId", captureId);
        String uri = this.instantiateUri("/v1/{merchantId}/captures/{captureId}/refund", pathContext);
        try {
            return this.communicator.post(uri, this.getClientHeaders(), null, (Object)body, RefundResponse.class, context);
        }
        catch (ResponseException e) {
            Class<RefundErrorResponse> errorType = RefundErrorResponse.class;
            RefundErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }
}

