/*
 * Decompiled with CFR 0.152.
 */
package com.worldline.connect.sdk.java.v1.merchant.disputes;

import com.worldline.connect.sdk.java.ApiResource;
import com.worldline.connect.sdk.java.CallContext;
import com.worldline.connect.sdk.java.communication.ResponseException;
import com.worldline.connect.sdk.java.v1.ExceptionFactory;
import com.worldline.connect.sdk.java.v1.domain.DisputeResponse;
import com.worldline.connect.sdk.java.v1.domain.ErrorResponse;
import com.worldline.connect.sdk.java.v1.domain.UploadDisputeFileResponse;
import com.worldline.connect.sdk.java.v1.merchant.disputes.UploadFileRequest;
import java.util.Map;
import java.util.TreeMap;

public class DisputesClient
extends ApiResource {
    private static final ExceptionFactory EXCEPTION_FACTORY = new ExceptionFactory();

    public DisputesClient(ApiResource parent, Map<String, String> pathContext) {
        super(parent, pathContext);
    }

    public DisputeResponse get(String disputeId) {
        return this.get(disputeId, null);
    }

    public DisputeResponse get(String disputeId, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("disputeId", disputeId);
        String uri = this.instantiateUri("/v1/{merchantId}/disputes/{disputeId}", pathContext);
        try {
            return this.communicator.get(uri, this.getClientHeaders(), null, DisputeResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    public DisputeResponse submit(String disputeId) {
        return this.submit(disputeId, null);
    }

    public DisputeResponse submit(String disputeId, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("disputeId", disputeId);
        String uri = this.instantiateUri("/v1/{merchantId}/disputes/{disputeId}/submit", pathContext);
        try {
            return this.communicator.post(uri, this.getClientHeaders(), null, (Object)null, DisputeResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    public DisputeResponse cancel(String disputeId) {
        return this.cancel(disputeId, null);
    }

    public DisputeResponse cancel(String disputeId, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("disputeId", disputeId);
        String uri = this.instantiateUri("/v1/{merchantId}/disputes/{disputeId}/cancel", pathContext);
        try {
            return this.communicator.post(uri, this.getClientHeaders(), null, (Object)null, DisputeResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    public UploadDisputeFileResponse uploadFile(String disputeId, UploadFileRequest body) {
        return this.uploadFile(disputeId, body, null);
    }

    public UploadDisputeFileResponse uploadFile(String disputeId, UploadFileRequest body, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("disputeId", disputeId);
        String uri = this.instantiateUri("/files/v1/{merchantId}/disputes/{disputeId}", pathContext);
        try {
            return this.communicator.post(uri, this.getClientHeaders(), null, (Object)body, UploadDisputeFileResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }
}

