/*
 * Decompiled with CFR 0.152.
 */
package com.worldline.connect.sdk.java.v1.merchant.files;

import com.worldline.connect.sdk.java.ApiResource;
import com.worldline.connect.sdk.java.BodyHandler;
import com.worldline.connect.sdk.java.CallContext;
import com.worldline.connect.sdk.java.communication.ResponseException;
import com.worldline.connect.sdk.java.v1.ExceptionFactory;
import com.worldline.connect.sdk.java.v1.domain.ErrorResponse;
import java.util.Map;
import java.util.TreeMap;

public class FilesClient
extends ApiResource {
    private static final ExceptionFactory EXCEPTION_FACTORY = new ExceptionFactory();

    public FilesClient(ApiResource parent, Map<String, String> pathContext) {
        super(parent, pathContext);
    }

    public void getFile(String fileId, BodyHandler bodyHandler) {
        this.getFile(fileId, bodyHandler, null);
    }

    public void getFile(String fileId, BodyHandler bodyHandler, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("fileId", fileId);
        String uri = this.instantiateUri("/files/v1/{merchantId}/files/{fileId}", pathContext);
        try {
            this.communicator.get(uri, this.getClientHeaders(), null, bodyHandler, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }
}

