/*
 * Decompiled with CFR 0.152.
 */
package com.worldline.connect.sdk.java.v1.merchant.hostedcheckouts;

import com.worldline.connect.sdk.java.ApiResource;
import com.worldline.connect.sdk.java.CallContext;
import com.worldline.connect.sdk.java.communication.ResponseException;
import com.worldline.connect.sdk.java.v1.ExceptionFactory;
import com.worldline.connect.sdk.java.v1.domain.CreateHostedCheckoutRequest;
import com.worldline.connect.sdk.java.v1.domain.CreateHostedCheckoutResponse;
import com.worldline.connect.sdk.java.v1.domain.ErrorResponse;
import com.worldline.connect.sdk.java.v1.domain.GetHostedCheckoutResponse;
import java.util.Map;
import java.util.TreeMap;

public class HostedcheckoutsClient
extends ApiResource {
    private static final ExceptionFactory EXCEPTION_FACTORY = new ExceptionFactory();

    public HostedcheckoutsClient(ApiResource parent, Map<String, String> pathContext) {
        super(parent, pathContext);
    }

    public CreateHostedCheckoutResponse create(CreateHostedCheckoutRequest body) {
        return this.create(body, null);
    }

    public CreateHostedCheckoutResponse create(CreateHostedCheckoutRequest body, CallContext context) {
        String uri = this.instantiateUri("/v1/{merchantId}/hostedcheckouts", null);
        try {
            return this.communicator.post(uri, this.getClientHeaders(), null, (Object)body, CreateHostedCheckoutResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    public GetHostedCheckoutResponse get(String hostedCheckoutId) {
        return this.get(hostedCheckoutId, null);
    }

    public GetHostedCheckoutResponse get(String hostedCheckoutId, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("hostedCheckoutId", hostedCheckoutId);
        String uri = this.instantiateUri("/v1/{merchantId}/hostedcheckouts/{hostedCheckoutId}", pathContext);
        try {
            return this.communicator.get(uri, this.getClientHeaders(), null, GetHostedCheckoutResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    public void delete(String hostedCheckoutId) {
        this.delete(hostedCheckoutId, null);
    }

    public void delete(String hostedCheckoutId, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("hostedCheckoutId", hostedCheckoutId);
        String uri = this.instantiateUri("/v1/{merchantId}/hostedcheckouts/{hostedCheckoutId}", pathContext);
        try {
            this.communicator.delete(uri, this.getClientHeaders(), null, Void.TYPE, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }
}

