/*
 * Decompiled with CFR 0.152.
 */
package com.worldline.connect.sdk.java.v1.merchant.mandates;

import com.worldline.connect.sdk.java.ApiResource;
import com.worldline.connect.sdk.java.CallContext;
import com.worldline.connect.sdk.java.communication.ResponseException;
import com.worldline.connect.sdk.java.v1.ExceptionFactory;
import com.worldline.connect.sdk.java.v1.domain.CreateMandateRequest;
import com.worldline.connect.sdk.java.v1.domain.CreateMandateResponse;
import com.worldline.connect.sdk.java.v1.domain.ErrorResponse;
import com.worldline.connect.sdk.java.v1.domain.GetMandateResponse;
import java.util.Map;
import java.util.TreeMap;

public class MandatesClient
extends ApiResource {
    private static final ExceptionFactory EXCEPTION_FACTORY = new ExceptionFactory();

    public MandatesClient(ApiResource parent, Map<String, String> pathContext) {
        super(parent, pathContext);
    }

    public CreateMandateResponse create(CreateMandateRequest body) {
        return this.create(body, null);
    }

    public CreateMandateResponse create(CreateMandateRequest body, CallContext context) {
        String uri = this.instantiateUri("/v1/{merchantId}/mandates", null);
        try {
            return this.communicator.post(uri, this.getClientHeaders(), null, (Object)body, CreateMandateResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    public CreateMandateResponse createWithMandateReference(String uniqueMandateReference, CreateMandateRequest body) {
        return this.createWithMandateReference(uniqueMandateReference, body, null);
    }

    public CreateMandateResponse createWithMandateReference(String uniqueMandateReference, CreateMandateRequest body, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("uniqueMandateReference", uniqueMandateReference);
        String uri = this.instantiateUri("/v1/{merchantId}/mandates/{uniqueMandateReference}", pathContext);
        try {
            return this.communicator.put(uri, this.getClientHeaders(), null, (Object)body, CreateMandateResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    public GetMandateResponse get(String uniqueMandateReference) {
        return this.get(uniqueMandateReference, null);
    }

    public GetMandateResponse get(String uniqueMandateReference, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("uniqueMandateReference", uniqueMandateReference);
        String uri = this.instantiateUri("/v1/{merchantId}/mandates/{uniqueMandateReference}", pathContext);
        try {
            return this.communicator.get(uri, this.getClientHeaders(), null, GetMandateResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    public GetMandateResponse block(String uniqueMandateReference) {
        return this.block(uniqueMandateReference, null);
    }

    public GetMandateResponse block(String uniqueMandateReference, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("uniqueMandateReference", uniqueMandateReference);
        String uri = this.instantiateUri("/v1/{merchantId}/mandates/{uniqueMandateReference}/block", pathContext);
        try {
            return this.communicator.post(uri, this.getClientHeaders(), null, (Object)null, GetMandateResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    public GetMandateResponse unblock(String uniqueMandateReference) {
        return this.unblock(uniqueMandateReference, null);
    }

    public GetMandateResponse unblock(String uniqueMandateReference, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("uniqueMandateReference", uniqueMandateReference);
        String uri = this.instantiateUri("/v1/{merchantId}/mandates/{uniqueMandateReference}/unblock", pathContext);
        try {
            return this.communicator.post(uri, this.getClientHeaders(), null, (Object)null, GetMandateResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    public GetMandateResponse revoke(String uniqueMandateReference) {
        return this.revoke(uniqueMandateReference, null);
    }

    public GetMandateResponse revoke(String uniqueMandateReference, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("uniqueMandateReference", uniqueMandateReference);
        String uri = this.instantiateUri("/v1/{merchantId}/mandates/{uniqueMandateReference}/revoke", pathContext);
        try {
            return this.communicator.post(uri, this.getClientHeaders(), null, (Object)null, GetMandateResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }
}

