/*
 * Decompiled with CFR 0.152.
 */
package com.worldline.connect.sdk.java.v1.merchant.payments;

import com.worldline.connect.sdk.java.ApiResource;
import com.worldline.connect.sdk.java.CallContext;
import com.worldline.connect.sdk.java.communication.ParamRequest;
import com.worldline.connect.sdk.java.communication.ResponseException;
import com.worldline.connect.sdk.java.v1.ExceptionFactory;
import com.worldline.connect.sdk.java.v1.domain.ApprovePaymentRequest;
import com.worldline.connect.sdk.java.v1.domain.CancelApprovalPaymentResponse;
import com.worldline.connect.sdk.java.v1.domain.CancelPaymentResponse;
import com.worldline.connect.sdk.java.v1.domain.CapturePaymentRequest;
import com.worldline.connect.sdk.java.v1.domain.CaptureResponse;
import com.worldline.connect.sdk.java.v1.domain.CapturesResponse;
import com.worldline.connect.sdk.java.v1.domain.CompletePaymentRequest;
import com.worldline.connect.sdk.java.v1.domain.CompletePaymentResponse;
import com.worldline.connect.sdk.java.v1.domain.CreateDisputeRequest;
import com.worldline.connect.sdk.java.v1.domain.CreatePaymentRequest;
import com.worldline.connect.sdk.java.v1.domain.CreatePaymentResponse;
import com.worldline.connect.sdk.java.v1.domain.CreateTokenResponse;
import com.worldline.connect.sdk.java.v1.domain.DeviceFingerprintDetails;
import com.worldline.connect.sdk.java.v1.domain.DisputeResponse;
import com.worldline.connect.sdk.java.v1.domain.DisputesResponse;
import com.worldline.connect.sdk.java.v1.domain.ErrorResponse;
import com.worldline.connect.sdk.java.v1.domain.FindPaymentsResponse;
import com.worldline.connect.sdk.java.v1.domain.PaymentApprovalResponse;
import com.worldline.connect.sdk.java.v1.domain.PaymentErrorResponse;
import com.worldline.connect.sdk.java.v1.domain.PaymentResponse;
import com.worldline.connect.sdk.java.v1.domain.RefundErrorResponse;
import com.worldline.connect.sdk.java.v1.domain.RefundRequest;
import com.worldline.connect.sdk.java.v1.domain.RefundResponse;
import com.worldline.connect.sdk.java.v1.domain.RefundsResponse;
import com.worldline.connect.sdk.java.v1.domain.ThirdPartyStatusResponse;
import com.worldline.connect.sdk.java.v1.domain.TokenizePaymentRequest;
import com.worldline.connect.sdk.java.v1.merchant.payments.FindPaymentsParams;
import java.util.Map;
import java.util.TreeMap;

public class PaymentsClient
extends ApiResource {
    private static final ExceptionFactory EXCEPTION_FACTORY = new ExceptionFactory();

    public PaymentsClient(ApiResource parent, Map<String, String> pathContext) {
        super(parent, pathContext);
    }

    public CreatePaymentResponse create(CreatePaymentRequest body) {
        return this.create(body, null);
    }

    public CreatePaymentResponse create(CreatePaymentRequest body, CallContext context) {
        String uri = this.instantiateUri("/v1/{merchantId}/payments", null);
        try {
            return this.communicator.post(uri, this.getClientHeaders(), null, (Object)body, CreatePaymentResponse.class, context);
        }
        catch (ResponseException e) {
            Class<PaymentErrorResponse> errorType = PaymentErrorResponse.class;
            PaymentErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    public FindPaymentsResponse find(FindPaymentsParams query) {
        return this.find(query, null);
    }

    public FindPaymentsResponse find(FindPaymentsParams query, CallContext context) {
        String uri = this.instantiateUri("/v1/{merchantId}/payments", null);
        try {
            return this.communicator.get(uri, this.getClientHeaders(), (ParamRequest)query, FindPaymentsResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    public PaymentResponse get(String paymentId) {
        return this.get(paymentId, null);
    }

    public PaymentResponse get(String paymentId, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("paymentId", paymentId);
        String uri = this.instantiateUri("/v1/{merchantId}/payments/{paymentId}", pathContext);
        try {
            return this.communicator.get(uri, this.getClientHeaders(), null, PaymentResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    public CompletePaymentResponse complete(String paymentId, CompletePaymentRequest body) {
        return this.complete(paymentId, body, null);
    }

    public CompletePaymentResponse complete(String paymentId, CompletePaymentRequest body, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("paymentId", paymentId);
        String uri = this.instantiateUri("/v1/{merchantId}/payments/{paymentId}/complete", pathContext);
        try {
            return this.communicator.post(uri, this.getClientHeaders(), null, (Object)body, CompletePaymentResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    public ThirdPartyStatusResponse thirdPartyStatus(String paymentId) {
        return this.thirdPartyStatus(paymentId, null);
    }

    public ThirdPartyStatusResponse thirdPartyStatus(String paymentId, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("paymentId", paymentId);
        String uri = this.instantiateUri("/v1/{merchantId}/payments/{paymentId}/thirdpartystatus", pathContext);
        try {
            return this.communicator.get(uri, this.getClientHeaders(), null, ThirdPartyStatusResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    public CreateTokenResponse tokenize(String paymentId, TokenizePaymentRequest body) {
        return this.tokenize(paymentId, body, null);
    }

    public CreateTokenResponse tokenize(String paymentId, TokenizePaymentRequest body, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("paymentId", paymentId);
        String uri = this.instantiateUri("/v1/{merchantId}/payments/{paymentId}/tokenize", pathContext);
        try {
            return this.communicator.post(uri, this.getClientHeaders(), null, (Object)body, CreateTokenResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    public PaymentResponse processchallenged(String paymentId) {
        return this.processchallenged(paymentId, null);
    }

    public PaymentResponse processchallenged(String paymentId, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("paymentId", paymentId);
        String uri = this.instantiateUri("/v1/{merchantId}/payments/{paymentId}/processchallenged", pathContext);
        try {
            return this.communicator.post(uri, this.getClientHeaders(), null, (Object)null, PaymentResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    public PaymentApprovalResponse approve(String paymentId, ApprovePaymentRequest body) {
        return this.approve(paymentId, body, null);
    }

    public PaymentApprovalResponse approve(String paymentId, ApprovePaymentRequest body, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("paymentId", paymentId);
        String uri = this.instantiateUri("/v1/{merchantId}/payments/{paymentId}/approve", pathContext);
        try {
            return this.communicator.post(uri, this.getClientHeaders(), null, (Object)body, PaymentApprovalResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    public CaptureResponse capture(String paymentId, CapturePaymentRequest body) {
        return this.capture(paymentId, body, null);
    }

    public CaptureResponse capture(String paymentId, CapturePaymentRequest body, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("paymentId", paymentId);
        String uri = this.instantiateUri("/v1/{merchantId}/payments/{paymentId}/capture", pathContext);
        try {
            return this.communicator.post(uri, this.getClientHeaders(), null, (Object)body, CaptureResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    public CancelApprovalPaymentResponse cancelapproval(String paymentId) {
        return this.cancelapproval(paymentId, null);
    }

    public CancelApprovalPaymentResponse cancelapproval(String paymentId, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("paymentId", paymentId);
        String uri = this.instantiateUri("/v1/{merchantId}/payments/{paymentId}/cancelapproval", pathContext);
        try {
            return this.communicator.post(uri, this.getClientHeaders(), null, (Object)null, CancelApprovalPaymentResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    public CapturesResponse captures(String paymentId) {
        return this.captures(paymentId, null);
    }

    public CapturesResponse captures(String paymentId, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("paymentId", paymentId);
        String uri = this.instantiateUri("/v1/{merchantId}/payments/{paymentId}/captures", pathContext);
        try {
            return this.communicator.get(uri, this.getClientHeaders(), null, CapturesResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    public RefundResponse refund(String paymentId, RefundRequest body) {
        return this.refund(paymentId, body, null);
    }

    public RefundResponse refund(String paymentId, RefundRequest body, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("paymentId", paymentId);
        String uri = this.instantiateUri("/v1/{merchantId}/payments/{paymentId}/refund", pathContext);
        try {
            return this.communicator.post(uri, this.getClientHeaders(), null, (Object)body, RefundResponse.class, context);
        }
        catch (ResponseException e) {
            Class<RefundErrorResponse> errorType = RefundErrorResponse.class;
            RefundErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    public RefundsResponse refunds(String paymentId) {
        return this.refunds(paymentId, null);
    }

    public RefundsResponse refunds(String paymentId, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("paymentId", paymentId);
        String uri = this.instantiateUri("/v1/{merchantId}/payments/{paymentId}/refunds", pathContext);
        try {
            return this.communicator.get(uri, this.getClientHeaders(), null, RefundsResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    public CancelPaymentResponse cancel(String paymentId) {
        return this.cancel(paymentId, null);
    }

    public CancelPaymentResponse cancel(String paymentId, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("paymentId", paymentId);
        String uri = this.instantiateUri("/v1/{merchantId}/payments/{paymentId}/cancel", pathContext);
        try {
            return this.communicator.post(uri, this.getClientHeaders(), null, (Object)null, CancelPaymentResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    public DisputeResponse dispute(String paymentId, CreateDisputeRequest body) {
        return this.dispute(paymentId, body, null);
    }

    public DisputeResponse dispute(String paymentId, CreateDisputeRequest body, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("paymentId", paymentId);
        String uri = this.instantiateUri("/v1/{merchantId}/payments/{paymentId}/dispute", pathContext);
        try {
            return this.communicator.post(uri, this.getClientHeaders(), null, (Object)body, DisputeResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    public DisputesResponse disputes(String paymentId) {
        return this.disputes(paymentId, null);
    }

    public DisputesResponse disputes(String paymentId, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("paymentId", paymentId);
        String uri = this.instantiateUri("/v1/{merchantId}/payments/{paymentId}/disputes", pathContext);
        try {
            return this.communicator.get(uri, this.getClientHeaders(), null, DisputesResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    public DeviceFingerprintDetails devicefingerprint(String paymentId) {
        return this.devicefingerprint(paymentId, null);
    }

    public DeviceFingerprintDetails devicefingerprint(String paymentId, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("paymentId", paymentId);
        String uri = this.instantiateUri("/v1/{merchantId}/payments/{paymentId}/devicefingerprint", pathContext);
        try {
            return this.communicator.get(uri, this.getClientHeaders(), null, DeviceFingerprintDetails.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }
}

