/*
 * Decompiled with CFR 0.152.
 */
package com.worldline.connect.sdk.java.v1.merchant.payouts;

import com.worldline.connect.sdk.java.ApiResource;
import com.worldline.connect.sdk.java.CallContext;
import com.worldline.connect.sdk.java.communication.ParamRequest;
import com.worldline.connect.sdk.java.communication.ResponseException;
import com.worldline.connect.sdk.java.v1.ExceptionFactory;
import com.worldline.connect.sdk.java.v1.domain.ApprovePayoutRequest;
import com.worldline.connect.sdk.java.v1.domain.CreatePayoutRequest;
import com.worldline.connect.sdk.java.v1.domain.ErrorResponse;
import com.worldline.connect.sdk.java.v1.domain.FindPayoutsResponse;
import com.worldline.connect.sdk.java.v1.domain.PayoutErrorResponse;
import com.worldline.connect.sdk.java.v1.domain.PayoutResponse;
import com.worldline.connect.sdk.java.v1.merchant.payouts.FindPayoutsParams;
import java.util.Map;
import java.util.TreeMap;

public class PayoutsClient
extends ApiResource {
    private static final ExceptionFactory EXCEPTION_FACTORY = new ExceptionFactory();

    public PayoutsClient(ApiResource parent, Map<String, String> pathContext) {
        super(parent, pathContext);
    }

    public PayoutResponse create(CreatePayoutRequest body) {
        return this.create(body, null);
    }

    public PayoutResponse create(CreatePayoutRequest body, CallContext context) {
        String uri = this.instantiateUri("/v1/{merchantId}/payouts", null);
        try {
            return this.communicator.post(uri, this.getClientHeaders(), null, (Object)body, PayoutResponse.class, context);
        }
        catch (ResponseException e) {
            Class<PayoutErrorResponse> errorType = PayoutErrorResponse.class;
            PayoutErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    public FindPayoutsResponse find(FindPayoutsParams query) {
        return this.find(query, null);
    }

    public FindPayoutsResponse find(FindPayoutsParams query, CallContext context) {
        String uri = this.instantiateUri("/v1/{merchantId}/payouts", null);
        try {
            return this.communicator.get(uri, this.getClientHeaders(), (ParamRequest)query, FindPayoutsResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    public PayoutResponse get(String payoutId) {
        return this.get(payoutId, null);
    }

    public PayoutResponse get(String payoutId, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("payoutId", payoutId);
        String uri = this.instantiateUri("/v1/{merchantId}/payouts/{payoutId}", pathContext);
        try {
            return this.communicator.get(uri, this.getClientHeaders(), null, PayoutResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    public PayoutResponse approve(String payoutId, ApprovePayoutRequest body) {
        return this.approve(payoutId, body, null);
    }

    public PayoutResponse approve(String payoutId, ApprovePayoutRequest body, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("payoutId", payoutId);
        String uri = this.instantiateUri("/v1/{merchantId}/payouts/{payoutId}/approve", pathContext);
        try {
            return this.communicator.post(uri, this.getClientHeaders(), null, (Object)body, PayoutResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    public void cancel(String payoutId) {
        this.cancel(payoutId, null);
    }

    public void cancel(String payoutId, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("payoutId", payoutId);
        String uri = this.instantiateUri("/v1/{merchantId}/payouts/{payoutId}/cancel", pathContext);
        try {
            this.communicator.post(uri, this.getClientHeaders(), null, (Object)null, Void.TYPE, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    public void cancelapproval(String payoutId) {
        this.cancelapproval(payoutId, null);
    }

    public void cancelapproval(String payoutId, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("payoutId", payoutId);
        String uri = this.instantiateUri("/v1/{merchantId}/payouts/{payoutId}/cancelapproval", pathContext);
        try {
            this.communicator.post(uri, this.getClientHeaders(), null, (Object)null, Void.TYPE, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }
}

