/*
 * Decompiled with CFR 0.152.
 */
package com.worldline.connect.sdk.java.v1.merchant.productgroups;

import com.worldline.connect.sdk.java.ApiResource;
import com.worldline.connect.sdk.java.CallContext;
import com.worldline.connect.sdk.java.communication.ParamRequest;
import com.worldline.connect.sdk.java.communication.ResponseException;
import com.worldline.connect.sdk.java.v1.ExceptionFactory;
import com.worldline.connect.sdk.java.v1.domain.DeviceFingerprintRequest;
import com.worldline.connect.sdk.java.v1.domain.DeviceFingerprintResponse;
import com.worldline.connect.sdk.java.v1.domain.ErrorResponse;
import com.worldline.connect.sdk.java.v1.domain.PaymentProductGroupResponse;
import com.worldline.connect.sdk.java.v1.domain.PaymentProductGroups;
import com.worldline.connect.sdk.java.v1.merchant.productgroups.FindProductgroupsParams;
import com.worldline.connect.sdk.java.v1.merchant.productgroups.GetProductgroupParams;
import java.util.Map;
import java.util.TreeMap;

public class ProductgroupsClient
extends ApiResource {
    private static final ExceptionFactory EXCEPTION_FACTORY = new ExceptionFactory();

    public ProductgroupsClient(ApiResource parent, Map<String, String> pathContext) {
        super(parent, pathContext);
    }

    public PaymentProductGroups find(FindProductgroupsParams query) {
        return this.find(query, null);
    }

    public PaymentProductGroups find(FindProductgroupsParams query, CallContext context) {
        String uri = this.instantiateUri("/v1/{merchantId}/productgroups", null);
        try {
            return this.communicator.get(uri, this.getClientHeaders(), (ParamRequest)query, PaymentProductGroups.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    public PaymentProductGroupResponse get(String paymentProductGroupId, GetProductgroupParams query) {
        return this.get(paymentProductGroupId, query, null);
    }

    public PaymentProductGroupResponse get(String paymentProductGroupId, GetProductgroupParams query, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("paymentProductGroupId", paymentProductGroupId);
        String uri = this.instantiateUri("/v1/{merchantId}/productgroups/{paymentProductGroupId}", pathContext);
        try {
            return this.communicator.get(uri, this.getClientHeaders(), (ParamRequest)query, PaymentProductGroupResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    public DeviceFingerprintResponse deviceFingerprint(String paymentProductGroupId, DeviceFingerprintRequest body) {
        return this.deviceFingerprint(paymentProductGroupId, body, null);
    }

    public DeviceFingerprintResponse deviceFingerprint(String paymentProductGroupId, DeviceFingerprintRequest body, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("paymentProductGroupId", paymentProductGroupId);
        String uri = this.instantiateUri("/v1/{merchantId}/productgroups/{paymentProductGroupId}/deviceFingerprint", pathContext);
        try {
            return this.communicator.post(uri, this.getClientHeaders(), null, (Object)body, DeviceFingerprintResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }
}

