/*
 * Decompiled with CFR 0.152.
 */
package com.worldline.connect.sdk.java.v1.merchant.products;

import com.worldline.connect.sdk.java.ApiResource;
import com.worldline.connect.sdk.java.CallContext;
import com.worldline.connect.sdk.java.communication.ParamRequest;
import com.worldline.connect.sdk.java.communication.ResponseException;
import com.worldline.connect.sdk.java.v1.ExceptionFactory;
import com.worldline.connect.sdk.java.v1.domain.CreatePaymentProductSessionRequest;
import com.worldline.connect.sdk.java.v1.domain.CreatePaymentProductSessionResponse;
import com.worldline.connect.sdk.java.v1.domain.DeviceFingerprintRequest;
import com.worldline.connect.sdk.java.v1.domain.DeviceFingerprintResponse;
import com.worldline.connect.sdk.java.v1.domain.Directory;
import com.worldline.connect.sdk.java.v1.domain.ErrorResponse;
import com.worldline.connect.sdk.java.v1.domain.GetCustomerDetailsRequest;
import com.worldline.connect.sdk.java.v1.domain.GetCustomerDetailsResponse;
import com.worldline.connect.sdk.java.v1.domain.PaymentProductNetworksResponse;
import com.worldline.connect.sdk.java.v1.domain.PaymentProductResponse;
import com.worldline.connect.sdk.java.v1.domain.PaymentProducts;
import com.worldline.connect.sdk.java.v1.merchant.products.DirectoryParams;
import com.worldline.connect.sdk.java.v1.merchant.products.FindProductsParams;
import com.worldline.connect.sdk.java.v1.merchant.products.GetProductParams;
import com.worldline.connect.sdk.java.v1.merchant.products.NetworksParams;
import java.util.Map;
import java.util.TreeMap;

public class ProductsClient
extends ApiResource {
    private static final ExceptionFactory EXCEPTION_FACTORY = new ExceptionFactory();

    public ProductsClient(ApiResource parent, Map<String, String> pathContext) {
        super(parent, pathContext);
    }

    public PaymentProducts find(FindProductsParams query) {
        return this.find(query, null);
    }

    public PaymentProducts find(FindProductsParams query, CallContext context) {
        String uri = this.instantiateUri("/v1/{merchantId}/products", null);
        try {
            return this.communicator.get(uri, this.getClientHeaders(), (ParamRequest)query, PaymentProducts.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    public PaymentProductResponse get(Integer paymentProductId, GetProductParams query) {
        return this.get(paymentProductId, query, null);
    }

    public PaymentProductResponse get(Integer paymentProductId, GetProductParams query, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("paymentProductId", paymentProductId.toString());
        String uri = this.instantiateUri("/v1/{merchantId}/products/{paymentProductId}", pathContext);
        try {
            return this.communicator.get(uri, this.getClientHeaders(), (ParamRequest)query, PaymentProductResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    public Directory directory(Integer paymentProductId, DirectoryParams query) {
        return this.directory(paymentProductId, query, null);
    }

    public Directory directory(Integer paymentProductId, DirectoryParams query, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("paymentProductId", paymentProductId.toString());
        String uri = this.instantiateUri("/v1/{merchantId}/products/{paymentProductId}/directory", pathContext);
        try {
            return this.communicator.get(uri, this.getClientHeaders(), (ParamRequest)query, Directory.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    public GetCustomerDetailsResponse customerDetails(Integer paymentProductId, GetCustomerDetailsRequest body) {
        return this.customerDetails(paymentProductId, body, null);
    }

    public GetCustomerDetailsResponse customerDetails(Integer paymentProductId, GetCustomerDetailsRequest body, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("paymentProductId", paymentProductId.toString());
        String uri = this.instantiateUri("/v1/{merchantId}/products/{paymentProductId}/customerDetails", pathContext);
        try {
            return this.communicator.post(uri, this.getClientHeaders(), null, (Object)body, GetCustomerDetailsResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    public DeviceFingerprintResponse deviceFingerprint(Integer paymentProductId, DeviceFingerprintRequest body) {
        return this.deviceFingerprint(paymentProductId, body, null);
    }

    public DeviceFingerprintResponse deviceFingerprint(Integer paymentProductId, DeviceFingerprintRequest body, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("paymentProductId", paymentProductId.toString());
        String uri = this.instantiateUri("/v1/{merchantId}/products/{paymentProductId}/deviceFingerprint", pathContext);
        try {
            return this.communicator.post(uri, this.getClientHeaders(), null, (Object)body, DeviceFingerprintResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    public PaymentProductNetworksResponse networks(Integer paymentProductId, NetworksParams query) {
        return this.networks(paymentProductId, query, null);
    }

    public PaymentProductNetworksResponse networks(Integer paymentProductId, NetworksParams query, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("paymentProductId", paymentProductId.toString());
        String uri = this.instantiateUri("/v1/{merchantId}/products/{paymentProductId}/networks", pathContext);
        try {
            return this.communicator.get(uri, this.getClientHeaders(), (ParamRequest)query, PaymentProductNetworksResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    public CreatePaymentProductSessionResponse sessions(Integer paymentProductId, CreatePaymentProductSessionRequest body) {
        return this.sessions(paymentProductId, body, null);
    }

    public CreatePaymentProductSessionResponse sessions(Integer paymentProductId, CreatePaymentProductSessionRequest body, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("paymentProductId", paymentProductId.toString());
        String uri = this.instantiateUri("/v1/{merchantId}/products/{paymentProductId}/sessions", pathContext);
        try {
            return this.communicator.post(uri, this.getClientHeaders(), null, (Object)body, CreatePaymentProductSessionResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }
}

