/*
 * Decompiled with CFR 0.152.
 */
package com.worldline.connect.sdk.java.v1.merchant.refunds;

import com.worldline.connect.sdk.java.ApiResource;
import com.worldline.connect.sdk.java.CallContext;
import com.worldline.connect.sdk.java.communication.ParamRequest;
import com.worldline.connect.sdk.java.communication.ResponseException;
import com.worldline.connect.sdk.java.v1.ExceptionFactory;
import com.worldline.connect.sdk.java.v1.domain.ApproveRefundRequest;
import com.worldline.connect.sdk.java.v1.domain.ErrorResponse;
import com.worldline.connect.sdk.java.v1.domain.FindRefundsResponse;
import com.worldline.connect.sdk.java.v1.domain.RefundResponse;
import com.worldline.connect.sdk.java.v1.merchant.refunds.FindRefundsParams;
import java.util.Map;
import java.util.TreeMap;

public class RefundsClient
extends ApiResource {
    private static final ExceptionFactory EXCEPTION_FACTORY = new ExceptionFactory();

    public RefundsClient(ApiResource parent, Map<String, String> pathContext) {
        super(parent, pathContext);
    }

    public FindRefundsResponse find(FindRefundsParams query) {
        return this.find(query, null);
    }

    public FindRefundsResponse find(FindRefundsParams query, CallContext context) {
        String uri = this.instantiateUri("/v1/{merchantId}/refunds", null);
        try {
            return this.communicator.get(uri, this.getClientHeaders(), (ParamRequest)query, FindRefundsResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    public RefundResponse get(String refundId) {
        return this.get(refundId, null);
    }

    public RefundResponse get(String refundId, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("refundId", refundId);
        String uri = this.instantiateUri("/v1/{merchantId}/refunds/{refundId}", pathContext);
        try {
            return this.communicator.get(uri, this.getClientHeaders(), null, RefundResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    public void approve(String refundId, ApproveRefundRequest body) {
        this.approve(refundId, body, null);
    }

    public void approve(String refundId, ApproveRefundRequest body, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("refundId", refundId);
        String uri = this.instantiateUri("/v1/{merchantId}/refunds/{refundId}/approve", pathContext);
        try {
            this.communicator.post(uri, this.getClientHeaders(), null, (Object)body, Void.TYPE, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    public void cancel(String refundId) {
        this.cancel(refundId, null);
    }

    public void cancel(String refundId, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("refundId", refundId);
        String uri = this.instantiateUri("/v1/{merchantId}/refunds/{refundId}/cancel", pathContext);
        try {
            this.communicator.post(uri, this.getClientHeaders(), null, (Object)null, Void.TYPE, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    public void cancelapproval(String refundId) {
        this.cancelapproval(refundId, null);
    }

    public void cancelapproval(String refundId, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("refundId", refundId);
        String uri = this.instantiateUri("/v1/{merchantId}/refunds/{refundId}/cancelapproval", pathContext);
        try {
            this.communicator.post(uri, this.getClientHeaders(), null, (Object)null, Void.TYPE, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }
}

