/*
 * Decompiled with CFR 0.152.
 */
package com.worldline.connect.sdk.java.v1.merchant.services;

import com.worldline.connect.sdk.java.ApiResource;
import com.worldline.connect.sdk.java.CallContext;
import com.worldline.connect.sdk.java.communication.ParamRequest;
import com.worldline.connect.sdk.java.communication.ResponseException;
import com.worldline.connect.sdk.java.v1.ExceptionFactory;
import com.worldline.connect.sdk.java.v1.domain.BankDetailsRequest;
import com.worldline.connect.sdk.java.v1.domain.BankDetailsResponse;
import com.worldline.connect.sdk.java.v1.domain.ConvertAmount;
import com.worldline.connect.sdk.java.v1.domain.ErrorResponse;
import com.worldline.connect.sdk.java.v1.domain.GetIINDetailsRequest;
import com.worldline.connect.sdk.java.v1.domain.GetIINDetailsResponse;
import com.worldline.connect.sdk.java.v1.domain.GetPrivacyPolicyResponse;
import com.worldline.connect.sdk.java.v1.domain.TestConnection;
import com.worldline.connect.sdk.java.v1.merchant.services.ConvertAmountParams;
import com.worldline.connect.sdk.java.v1.merchant.services.PrivacypolicyParams;
import java.util.Map;

public class ServicesClient
extends ApiResource {
    private static final ExceptionFactory EXCEPTION_FACTORY = new ExceptionFactory();

    public ServicesClient(ApiResource parent, Map<String, String> pathContext) {
        super(parent, pathContext);
    }

    public ConvertAmount convertAmount(ConvertAmountParams query) {
        return this.convertAmount(query, null);
    }

    public ConvertAmount convertAmount(ConvertAmountParams query, CallContext context) {
        String uri = this.instantiateUri("/v1/{merchantId}/services/convert/amount", null);
        try {
            return this.communicator.get(uri, this.getClientHeaders(), (ParamRequest)query, ConvertAmount.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    public BankDetailsResponse bankaccount(BankDetailsRequest body) {
        return this.bankaccount(body, null);
    }

    public BankDetailsResponse bankaccount(BankDetailsRequest body, CallContext context) {
        String uri = this.instantiateUri("/v1/{merchantId}/services/convert/bankaccount", null);
        try {
            return this.communicator.post(uri, this.getClientHeaders(), null, (Object)body, BankDetailsResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    public GetIINDetailsResponse getIINdetails(GetIINDetailsRequest body) {
        return this.getIINdetails(body, null);
    }

    public GetIINDetailsResponse getIINdetails(GetIINDetailsRequest body, CallContext context) {
        String uri = this.instantiateUri("/v1/{merchantId}/services/getIINdetails", null);
        try {
            return this.communicator.post(uri, this.getClientHeaders(), null, (Object)body, GetIINDetailsResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    public GetPrivacyPolicyResponse privacypolicy(PrivacypolicyParams query) {
        return this.privacypolicy(query, null);
    }

    public GetPrivacyPolicyResponse privacypolicy(PrivacypolicyParams query, CallContext context) {
        String uri = this.instantiateUri("/v1/{merchantId}/services/privacypolicy", null);
        try {
            return this.communicator.get(uri, this.getClientHeaders(), (ParamRequest)query, GetPrivacyPolicyResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    public TestConnection testconnection() {
        return this.testconnection(null);
    }

    public TestConnection testconnection(CallContext context) {
        String uri = this.instantiateUri("/v1/{merchantId}/services/testconnection", null);
        try {
            return this.communicator.get(uri, this.getClientHeaders(), null, TestConnection.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }
}

