/*
 * Decompiled with CFR 0.152.
 */
package com.worldline.connect.sdk.java.v1.merchant.tokens;

import com.worldline.connect.sdk.java.ApiResource;
import com.worldline.connect.sdk.java.CallContext;
import com.worldline.connect.sdk.java.communication.ParamRequest;
import com.worldline.connect.sdk.java.communication.ResponseException;
import com.worldline.connect.sdk.java.v1.ExceptionFactory;
import com.worldline.connect.sdk.java.v1.domain.ApproveTokenRequest;
import com.worldline.connect.sdk.java.v1.domain.CreateTokenRequest;
import com.worldline.connect.sdk.java.v1.domain.CreateTokenResponse;
import com.worldline.connect.sdk.java.v1.domain.ErrorResponse;
import com.worldline.connect.sdk.java.v1.domain.TokenResponse;
import com.worldline.connect.sdk.java.v1.domain.UpdateTokenRequest;
import com.worldline.connect.sdk.java.v1.merchant.tokens.DeleteTokenParams;
import java.util.Map;
import java.util.TreeMap;

public class TokensClient
extends ApiResource {
    private static final ExceptionFactory EXCEPTION_FACTORY = new ExceptionFactory();

    public TokensClient(ApiResource parent, Map<String, String> pathContext) {
        super(parent, pathContext);
    }

    public CreateTokenResponse create(CreateTokenRequest body) {
        return this.create(body, null);
    }

    public CreateTokenResponse create(CreateTokenRequest body, CallContext context) {
        String uri = this.instantiateUri("/v1/{merchantId}/tokens", null);
        try {
            return this.communicator.post(uri, this.getClientHeaders(), null, (Object)body, CreateTokenResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    public TokenResponse get(String tokenId) {
        return this.get(tokenId, null);
    }

    public TokenResponse get(String tokenId, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("tokenId", tokenId);
        String uri = this.instantiateUri("/v1/{merchantId}/tokens/{tokenId}", pathContext);
        try {
            return this.communicator.get(uri, this.getClientHeaders(), null, TokenResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    public void update(String tokenId, UpdateTokenRequest body) {
        this.update(tokenId, body, null);
    }

    public void update(String tokenId, UpdateTokenRequest body, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("tokenId", tokenId);
        String uri = this.instantiateUri("/v1/{merchantId}/tokens/{tokenId}", pathContext);
        try {
            this.communicator.put(uri, this.getClientHeaders(), null, (Object)body, Void.TYPE, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    public void delete(String tokenId, DeleteTokenParams query) {
        this.delete(tokenId, query, null);
    }

    public void delete(String tokenId, DeleteTokenParams query, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("tokenId", tokenId);
        String uri = this.instantiateUri("/v1/{merchantId}/tokens/{tokenId}", pathContext);
        try {
            this.communicator.delete(uri, this.getClientHeaders(), (ParamRequest)query, Void.TYPE, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    public void approvesepadirectdebit(String tokenId, ApproveTokenRequest body) {
        this.approvesepadirectdebit(tokenId, body, null);
    }

    public void approvesepadirectdebit(String tokenId, ApproveTokenRequest body, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("tokenId", tokenId);
        String uri = this.instantiateUri("/v1/{merchantId}/tokens/{tokenId}/approvesepadirectdebit", pathContext);
        try {
            this.communicator.post(uri, this.getClientHeaders(), null, (Object)body, Void.TYPE, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }
}

