/*
 * Decompiled with CFR 0.152.
 */
package com.worldline.connect.sdk.java.v1.webhooks;

import com.worldline.connect.sdk.java.communication.RequestHeader;
import com.worldline.connect.sdk.java.json.Marshaller;
import com.worldline.connect.sdk.java.v1.domain.WebhooksEvent;
import com.worldline.connect.sdk.java.webhooks.ApiVersionMismatchException;
import com.worldline.connect.sdk.java.webhooks.SecretKeyStore;
import com.worldline.connect.sdk.java.webhooks.SignatureValidator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class WebhooksHelper {
    private final Marshaller marshaller;
    private final SignatureValidator signatureValidator;

    public WebhooksHelper(Marshaller marshaller, SecretKeyStore secretKeyStore) {
        if (marshaller == null) {
            throw new IllegalArgumentException("marshaller is required");
        }
        this.marshaller = marshaller;
        this.signatureValidator = new SignatureValidator(secretKeyStore);
    }

    public WebhooksEvent unmarshal(InputStream bodyStream, List<RequestHeader> requestHeaders) throws IOException {
        byte[] bodyBytes = WebhooksHelper.getContent(bodyStream);
        return this.unmarshal(bodyBytes, requestHeaders);
    }

    private static byte[] getContent(InputStream bodyStream) throws IOException {
        int len;
        ByteArrayOutputStream output = new ByteArrayOutputStream(4096);
        byte[] buffer = new byte[4096];
        while ((len = bodyStream.read(buffer)) != -1) {
            output.write(buffer, 0, len);
        }
        return output.toByteArray();
    }

    public WebhooksEvent unmarshal(byte[] body, List<RequestHeader> requestHeaders) {
        this.signatureValidator.validate(body, requestHeaders);
        WebhooksEvent event = this.marshaller.unmarshal(new ByteArrayInputStream(body), WebhooksEvent.class);
        WebhooksHelper.validateApiVersion(event);
        return event;
    }

    public WebhooksEvent unmarshal(String body, List<RequestHeader> requestHeaders) {
        this.signatureValidator.validate(body, requestHeaders);
        WebhooksEvent event = this.marshaller.unmarshal(body, WebhooksEvent.class);
        WebhooksHelper.validateApiVersion(event);
        return event;
    }

    private static void validateApiVersion(WebhooksEvent event) {
        if (!"v1".equals(event.getApiVersion())) {
            throw new ApiVersionMismatchException(event.getApiVersion(), "v1");
        }
    }
}

