/*
 * Decompiled with CFR 0.152.
 */
package com.worldline.connect.sdk.java.webhooks;

import com.worldline.connect.sdk.java.communication.RequestHeader;
import com.worldline.connect.sdk.java.webhooks.SecretKeyStore;
import com.worldline.connect.sdk.java.webhooks.SignatureValidationException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.List;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class SignatureValidator {
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private final SecretKeyStore secretKeyStore;

    public SignatureValidator(SecretKeyStore secretKeyStore) {
        if (secretKeyStore == null) {
            throw new IllegalArgumentException("secretKeyStore is required");
        }
        this.secretKeyStore = secretKeyStore;
    }

    public void validate(byte[] body, List<RequestHeader> requestHeaders) {
        try {
            this.validateBody(body, requestHeaders);
        }
        catch (GeneralSecurityException e) {
            throw new SignatureValidationException(e);
        }
    }

    public void validate(String body, List<RequestHeader> requestHeaders) {
        this.validate(body.getBytes(CHARSET), requestHeaders);
    }

    private void validateBody(byte[] body, List<RequestHeader> requestHeaders) throws GeneralSecurityException {
        String signature = SignatureValidator.getHeaderValue(requestHeaders, "X-GCS-Signature");
        String keyId = SignatureValidator.getHeaderValue(requestHeaders, "X-GCS-KeyId");
        String secretKey = this.secretKeyStore.getSecretKey(keyId);
        Mac hmac = Mac.getInstance("HmacSHA256");
        SecretKeySpec key = new SecretKeySpec(secretKey.getBytes(CHARSET), "HmacSHA256");
        hmac.init(key);
        byte[] unencodedResult = hmac.doFinal(body);
        byte[] expectedSignature = Base64.getEncoder().encode(unencodedResult);
        boolean isValid = MessageDigest.isEqual(signature.getBytes(CHARSET), expectedSignature);
        if (!isValid) {
            throw new SignatureValidationException("failed to validate signature '" + signature + "'");
        }
    }

    private static String getHeaderValue(List<RequestHeader> requestHeaders, String headerName) {
        String value = null;
        for (RequestHeader header : requestHeaders) {
            if (!headerName.equalsIgnoreCase(header.getName())) continue;
            if (value == null) {
                value = header.getValue();
                continue;
            }
            throw new SignatureValidationException("enocuntered multiple occurrences of header '" + headerName + "'");
        }
        if (value == null) {
            throw new SignatureValidationException("could not find header '" + headerName + "'");
        }
        return value;
    }
}

