/*
 * Decompiled with CFR 0.152.
 */
package com.onlinepayments;

import com.onlinepayments.domain.APIError;
import java.util.Collections;
import java.util.List;

public class ApiException
extends RuntimeException {
    private final int statusCode;
    private final String responseBody;
    private final String errorId;
    private final List<APIError> errors;

    public ApiException(int statusCode, String responseBody, String errorId, List<APIError> errors) {
        this("the payment platform returned an error response", statusCode, responseBody, errorId, errors);
    }

    public ApiException(String message, int statusCode, String responseBody, String errorId, List<APIError> errors) {
        super(message);
        this.statusCode = statusCode;
        this.responseBody = responseBody;
        this.errorId = errorId;
        this.errors = errors == null ? Collections.emptyList() : errors;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public String getErrorId() {
        return this.errorId;
    }

    public List<APIError> getErrors() {
        return this.errors;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        if (this.statusCode > 0) {
            sb.append("; statusCode=").append(this.statusCode);
        }
        if (this.responseBody != null && this.responseBody.length() > 0) {
            sb.append("; responseBody='").append(this.responseBody).append("'");
        }
        return sb.toString();
    }
}

