/*
 * Decompiled with CFR 0.152.
 */
package com.onlinepayments;

import com.onlinepayments.Communicator;
import com.onlinepayments.communication.RequestHeader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class ApiResource {
    private final ApiResource parent;
    protected final Communicator communicator;
    private final Map<String, String> pathContext;
    protected final String clientMetaInfo;

    protected ApiResource(ApiResource parent, Map<String, String> pathContext) {
        if (parent == null) {
            throw new IllegalArgumentException("parent is required");
        }
        this.parent = parent;
        this.communicator = parent.communicator;
        this.pathContext = pathContext;
        this.clientMetaInfo = parent.clientMetaInfo;
    }

    protected ApiResource(Communicator communicator, String clientMetaInfo, Map<String, String> pathContext) {
        if (communicator == null) {
            throw new IllegalArgumentException("communicator is required");
        }
        this.parent = null;
        this.communicator = communicator;
        this.pathContext = pathContext;
        this.clientMetaInfo = clientMetaInfo;
    }

    protected List<RequestHeader> getClientHeaders() {
        ArrayList<RequestHeader> clientHeaders = new ArrayList<RequestHeader>();
        if (this.clientMetaInfo != null) {
            clientHeaders.add(new RequestHeader("X-GCS-ClientMetaInfo", this.clientMetaInfo));
        }
        return clientHeaders;
    }

    protected String instantiateUri(String uri, Map<String, String> pathContext) {
        uri = ApiResource.replaceAll(uri, pathContext);
        uri = this.instantiateUri(uri);
        return uri;
    }

    private String instantiateUri(String uri) {
        uri = ApiResource.replaceAll(uri, this.pathContext);
        if (this.parent != null) {
            uri = this.parent.instantiateUri(uri);
        }
        return uri;
    }

    private static String replaceAll(String uri, Map<String, String> pathContext) {
        if (pathContext != null) {
            for (Map.Entry<String, String> entry : pathContext.entrySet()) {
                uri = uri.replace(String.format("{%s}", entry.getKey()), entry.getValue());
            }
        }
        return uri;
    }
}

