/*
 * Decompiled with CFR 0.152.
 */
package com.onlinepayments;

import com.onlinepayments.ApiResource;
import com.onlinepayments.ClientInterface;
import com.onlinepayments.Communicator;
import com.onlinepayments.logging.BodyObfuscator;
import com.onlinepayments.logging.CommunicatorLogger;
import com.onlinepayments.logging.HeaderObfuscator;
import com.onlinepayments.merchant.MerchantClient;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class Client
extends ApiResource
implements ClientInterface {
    private static final Charset CHARSET = StandardCharsets.UTF_8;

    public Client(Communicator communicator) {
        this(communicator, null);
    }

    private Client(Communicator communicator, String clientMetaInfo) {
        super(communicator, clientMetaInfo, null);
    }

    @Override
    public ClientInterface withClientMetaInfo(String clientMetaInfo) {
        if (this.clientMetaInfo == null && clientMetaInfo == null) {
            return this;
        }
        if (clientMetaInfo == null) {
            return new Client(this.communicator, null);
        }
        this.communicator.getMarshaller().unmarshal(clientMetaInfo, Object.class);
        clientMetaInfo = Base64.getEncoder().encodeToString(clientMetaInfo.getBytes(CHARSET));
        return clientMetaInfo.equals(this.clientMetaInfo) ? this : new Client(this.communicator, clientMetaInfo);
    }

    @Override
    public void closeIdleConnections(long idleTime, TimeUnit timeUnit) {
        this.communicator.closeIdleConnections(idleTime, timeUnit);
    }

    @Override
    public void closeExpiredConnections() {
        this.communicator.closeExpiredConnections();
    }

    @Override
    public void setBodyObfuscator(BodyObfuscator bodyObfuscator) {
        this.communicator.setBodyObfuscator(bodyObfuscator);
    }

    @Override
    public void setHeaderObfuscator(HeaderObfuscator headerObfuscator) {
        this.communicator.setHeaderObfuscator(headerObfuscator);
    }

    @Override
    public void enableLogging(CommunicatorLogger communicatorLogger) {
        this.communicator.enableLogging(communicatorLogger);
    }

    @Override
    public void disableLogging() {
        this.communicator.disableLogging();
    }

    @Override
    public void close() throws IOException {
        this.communicator.close();
    }

    @Override
    public MerchantClient merchant(String merchantId) {
        TreeMap<String, String> subContext = new TreeMap<String, String>();
        subContext.put("merchantId", merchantId);
        return new MerchantClient(this, subContext);
    }
}

