/*
 * Decompiled with CFR 0.152.
 */
package com.onlinepayments;

import com.onlinepayments.Communicator;
import com.onlinepayments.DefaultCommunicator;
import com.onlinepayments.authentication.Authenticator;
import com.onlinepayments.communication.Connection;
import com.onlinepayments.communication.MetadataProvider;
import com.onlinepayments.json.Marshaller;
import java.net.URI;

public class CommunicatorBuilder {
    private URI apiEndpoint;
    private Connection connection;
    private MetadataProvider metadataProvider;
    private Authenticator authenticator;
    private Marshaller marshaller;

    public CommunicatorBuilder withAPIEndpoint(URI apiEndpoint) {
        this.apiEndpoint = apiEndpoint;
        return this;
    }

    public CommunicatorBuilder withConnection(Connection connection) {
        this.connection = connection;
        return this;
    }

    public CommunicatorBuilder withAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
        return this;
    }

    public CommunicatorBuilder withMetadataProvider(MetadataProvider metadataProvider) {
        this.metadataProvider = metadataProvider;
        return this;
    }

    public CommunicatorBuilder withMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
        return this;
    }

    public Communicator build() {
        return new DefaultCommunicator(this.apiEndpoint, this.connection, this.authenticator, this.metadataProvider, this.marshaller);
    }
}

