/*
 * Decompiled with CFR 0.152.
 */
package com.onlinepayments;

import com.onlinepayments.ProxyConfiguration;
import com.onlinepayments.authentication.AuthorizationType;
import com.onlinepayments.domain.ShoppingCartExtension;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;

public class CommunicatorConfiguration {
    public static final int DEFAULT_MAX_CONNECTIONS = 10;
    public static final Set<String> DEFAULT_HTTPS_PROTOCOLS = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList("TLSv1.1", "TLSv1.2")));
    private static final Pattern COMMA_SEPARATOR_PATTERN = Pattern.compile("\\s*,\\s*");
    private URI apiEndpoint;
    private int connectTimeout;
    private int socketTimeout;
    private int maxConnections = 10;
    private boolean connectionReuse = true;
    private AuthorizationType authorizationType;
    private String apiKeyId;
    private String secretApiKey;
    private ProxyConfiguration proxyConfiguration;
    private Set<String> httpsProtocols = new LinkedHashSet<String>(DEFAULT_HTTPS_PROTOCOLS);
    private String integrator;
    private ShoppingCartExtension shoppingCartExtension;

    public CommunicatorConfiguration() {
    }

    public CommunicatorConfiguration(Properties properties) {
        if (properties != null) {
            String httpsProtocolString;
            this.apiEndpoint = CommunicatorConfiguration.getApiEndpoint(properties);
            this.authorizationType = AuthorizationType.valueOf(properties.getProperty("onlinePayments.api.authorizationType"));
            this.connectTimeout = Integer.parseInt(properties.getProperty("onlinePayments.api.connectTimeout"));
            this.socketTimeout = Integer.parseInt(properties.getProperty("onlinePayments.api.socketTimeout"));
            this.maxConnections = CommunicatorConfiguration.getProperty(properties, "onlinePayments.api.maxConnections", 10);
            String proxyURI = properties.getProperty("onlinePayments.api.proxy.uri");
            String proxyUser = properties.getProperty("onlinePayments.api.proxy.username");
            String proxyPass = properties.getProperty("onlinePayments.api.proxy.password");
            if (proxyURI != null) {
                this.proxyConfiguration = new ProxyConfiguration(URI.create(proxyURI), proxyUser, proxyPass);
            }
            if ((httpsProtocolString = properties.getProperty("onlinePayments.api.https.protocols")) != null) {
                this.httpsProtocols.clear();
                this.httpsProtocols.addAll(Arrays.asList(COMMA_SEPARATOR_PATTERN.split(httpsProtocolString.trim())));
            }
            this.connectionReuse = Boolean.parseBoolean(properties.getProperty("onlinePayments.api.connectionReuse", "true"));
            this.integrator = properties.getProperty("onlinePayments.api.integrator");
            this.shoppingCartExtension = CommunicatorConfiguration.getShoppingCartExtension(properties);
        }
    }

    private static int getProperty(Properties properties, String key, int defaultValue) {
        String propertyValue = properties.getProperty(key, null);
        return propertyValue != null ? Integer.parseInt(propertyValue) : defaultValue;
    }

    private static URI getApiEndpoint(Properties properties) {
        String host = properties.getProperty("onlinePayments.api.endpoint.host");
        String scheme = properties.getProperty("onlinePayments.api.endpoint.scheme");
        String port = properties.getProperty("onlinePayments.api.endpoint.port");
        return CommunicatorConfiguration.createURI(scheme != null ? scheme : "https", host, port != null ? Integer.parseInt(port) : -1);
    }

    private static URI createURI(String scheme, String host, int port) {
        try {
            return new URI(scheme, null, host, port, null, null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Unable to construct API endpoint URI", e);
        }
    }

    private static ShoppingCartExtension getShoppingCartExtension(Properties properties) {
        String creator = properties.getProperty("onlinePayments.api.shoppingCartExtension.creator");
        String name = properties.getProperty("onlinePayments.api.shoppingCartExtension.name");
        String version = properties.getProperty("onlinePayments.api.shoppingCartExtension.version");
        String extensionId = properties.getProperty("onlinePayments.api.shoppingCartExtension.extensionId");
        if (creator == null && name == null && version == null && extensionId == null) {
            return null;
        }
        if (extensionId == null) {
            return new ShoppingCartExtension(creator, name, version);
        }
        return new ShoppingCartExtension(creator, name, version, extensionId);
    }

    public URI getApiEndpoint() {
        return this.apiEndpoint;
    }

    public void setApiEndpoint(URI apiEndpoint) {
        if (apiEndpoint != null && apiEndpoint.getPath() != null && !apiEndpoint.getPath().isEmpty()) {
            throw new IllegalArgumentException("apiEndpoint should not contain a path");
        }
        if (apiEndpoint != null && (apiEndpoint.getUserInfo() != null || apiEndpoint.getQuery() != null || apiEndpoint.getFragment() != null)) {
            throw new IllegalArgumentException("apiEndpoint should not contain user info, query or fragment");
        }
        this.apiEndpoint = apiEndpoint;
    }

    public CommunicatorConfiguration withApiEndpoint(URI apiEndpoint) {
        this.setApiEndpoint(apiEndpoint);
        return this;
    }

    public String getApiKeyId() {
        return this.apiKeyId;
    }

    public void setApiKeyId(String apiKeyId) {
        this.apiKeyId = apiKeyId;
    }

    public CommunicatorConfiguration withApiKeyId(String apiKeyId) {
        this.setApiKeyId(apiKeyId);
        return this;
    }

    public String getSecretApiKey() {
        return this.secretApiKey;
    }

    public void setSecretApiKey(String secretApiKey) {
        this.secretApiKey = secretApiKey;
    }

    public CommunicatorConfiguration withSecretApiKey(String secretApiKey) {
        this.setSecretApiKey(secretApiKey);
        return this;
    }

    public AuthorizationType getAuthorizationType() {
        return this.authorizationType;
    }

    public void setAuthorizationType(AuthorizationType authorizationType) {
        this.authorizationType = authorizationType;
    }

    public CommunicatorConfiguration withAuthorizationType(AuthorizationType authorizationType) {
        this.setAuthorizationType(authorizationType);
        return this;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public CommunicatorConfiguration withConnectTimeout(int connectTimeout) {
        this.setConnectTimeout(connectTimeout);
        return this;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public CommunicatorConfiguration withSocketTimeout(int socketTimeout) {
        this.setSocketTimeout(socketTimeout);
        return this;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public CommunicatorConfiguration withMaxConnections(int maxConnections) {
        this.setMaxConnections(maxConnections);
        return this;
    }

    public boolean isConnectionReuse() {
        return this.connectionReuse;
    }

    public void setConnectionReuse(boolean connectionReuse) {
        this.connectionReuse = connectionReuse;
    }

    public CommunicatorConfiguration withConnectionReuse(boolean connectionReuse) {
        this.connectionReuse = connectionReuse;
        return this;
    }

    public ProxyConfiguration getProxyConfiguration() {
        return this.proxyConfiguration;
    }

    public void setProxyConfiguration(ProxyConfiguration proxyConfiguration) {
        this.proxyConfiguration = proxyConfiguration;
    }

    public CommunicatorConfiguration withProxyConfiguration(ProxyConfiguration proxyConfiguration) {
        this.setProxyConfiguration(proxyConfiguration);
        return this;
    }

    public Set<String> getHttpsProtocols() {
        if (this.httpsProtocols == null) {
            this.httpsProtocols = new LinkedHashSet<String>();
        }
        return this.httpsProtocols;
    }

    public void setHttpsProtocols(Set<String> httpsProtocols) {
        this.httpsProtocols = httpsProtocols;
    }

    public CommunicatorConfiguration withHttpsProtocols(Collection<String> httpsProtocols) {
        this.getHttpsProtocols().clear();
        this.getHttpsProtocols().addAll(httpsProtocols);
        return this;
    }

    public CommunicatorConfiguration withHttpsProtocols(String ... httpsProtocols) {
        return this.withHttpsProtocols(Arrays.asList(httpsProtocols));
    }

    public String getIntegrator() {
        return this.integrator;
    }

    public void setIntegrator(String integrator) {
        this.integrator = integrator;
    }

    public CommunicatorConfiguration withIntegrator(String integrator) {
        this.setIntegrator(integrator);
        return this;
    }

    public ShoppingCartExtension getShoppingCartExtension() {
        return this.shoppingCartExtension;
    }

    public void setShoppingCartExtension(ShoppingCartExtension shoppingCartExtension) {
        this.shoppingCartExtension = shoppingCartExtension;
    }

    public CommunicatorConfiguration withShoppingCartExtension(ShoppingCartExtension shoppingCartExtension) {
        this.setShoppingCartExtension(shoppingCartExtension);
        return this;
    }
}

