/*
 * Decompiled with CFR 0.152.
 */
package com.onlinepayments;

import com.onlinepayments.DeclinedTransactionException;
import com.onlinepayments.domain.CreatePaymentResponse;
import com.onlinepayments.domain.PaymentErrorResponse;
import java.util.Optional;

public class DeclinedPaymentException
extends DeclinedTransactionException {
    private final PaymentErrorResponse response;

    public DeclinedPaymentException(int statusCode, String responseBody, PaymentErrorResponse response) {
        super(DeclinedPaymentException.buildMessage(response), statusCode, responseBody, response != null ? response.getErrorId() : null, response != null ? response.getErrors() : null);
        this.response = response;
    }

    private static String buildMessage(PaymentErrorResponse response) {
        return Optional.ofNullable(response).map(PaymentErrorResponse::getPaymentResult).map(CreatePaymentResponse::getPayment).map(payment -> String.format("declined payment '%s' with status '%s'", payment.getId(), payment.getStatus())).orElse("the payment platform returned a declined payment response");
    }

    public CreatePaymentResponse getCreatePaymentResponse() {
        return this.response == null ? null : this.response.getPaymentResult();
    }
}

