/*
 * Decompiled with CFR 0.152.
 */
package com.onlinepayments;

import com.onlinepayments.Client;
import com.onlinepayments.ClientInterface;
import com.onlinepayments.Communicator;
import com.onlinepayments.CommunicatorBuilder;
import com.onlinepayments.CommunicatorConfiguration;
import com.onlinepayments.DefaultCommunicator;
import com.onlinepayments.authentication.Authenticator;
import com.onlinepayments.authentication.AuthorizationType;
import com.onlinepayments.authentication.V1HmacAuthenticator;
import com.onlinepayments.communication.Connection;
import com.onlinepayments.communication.DefaultConnectionBuilder;
import com.onlinepayments.communication.MetadataProvider;
import com.onlinepayments.communication.MetadataProviderBuilder;
import com.onlinepayments.json.DefaultMarshaller;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Properties;

public final class Factory {
    private Factory() {
    }

    public static CommunicatorConfiguration createConfiguration(URI configurationFileUri, String apiKeyId, String secretApiKey) {
        CommunicatorConfiguration communicatorConfiguration;
        block8: {
            Properties properties = new Properties();
            InputStream configurationFileInputStream = configurationFileUri.toURL().openStream();
            try {
                properties.load(configurationFileInputStream);
                communicatorConfiguration = new CommunicatorConfiguration(properties).withApiKeyId(apiKeyId).withSecretApiKey(secretApiKey);
                if (configurationFileInputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (configurationFileInputStream != null) {
                        try {
                            configurationFileInputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Unable to load properties", e);
                }
            }
            configurationFileInputStream.close();
        }
        return communicatorConfiguration;
    }

    public static CommunicatorBuilder createCommunicatorBuilder(URI configurationFileUri, String apiKeyId, String secretApiKey) {
        CommunicatorConfiguration configuration = Factory.createConfiguration(configurationFileUri, apiKeyId, secretApiKey);
        return Factory.createCommunicatorBuilder(configuration);
    }

    public static CommunicatorBuilder createCommunicatorBuilder(CommunicatorConfiguration configuration) {
        MetadataProvider metadataProvider = new MetadataProviderBuilder(configuration.getIntegrator()).withShoppingCartExtension(configuration.getShoppingCartExtension()).build();
        return new CommunicatorBuilder().withAPIEndpoint(configuration.getApiEndpoint()).withConnection(new DefaultConnectionBuilder(configuration.getConnectTimeout(), configuration.getSocketTimeout()).withMaxConnections(configuration.getMaxConnections()).withConnectionReuse(configuration.isConnectionReuse()).withProxyConfiguration(configuration.getProxyConfiguration()).withHttpsProtocols(configuration.getHttpsProtocols()).build()).withMetadataProvider(metadataProvider).withAuthenticator(Factory.getAuthenticator(configuration)).withMarshaller(DefaultMarshaller.INSTANCE);
    }

    private static Authenticator getAuthenticator(CommunicatorConfiguration configuration) {
        if (configuration.getAuthorizationType() == AuthorizationType.V1HMAC) {
            return new V1HmacAuthenticator(configuration);
        }
        throw new IllegalStateException("Unknown authorizationType " + (Object)((Object)configuration.getAuthorizationType()));
    }

    public static Communicator createCommunicator(URI configurationFileUri, String apiKeyId, String secretApiKey) {
        CommunicatorConfiguration configuration = Factory.createConfiguration(configurationFileUri, apiKeyId, secretApiKey);
        return Factory.createCommunicator(configuration);
    }

    public static Communicator createCommunicator(CommunicatorConfiguration configuration) {
        CommunicatorBuilder communicatorBuilder = Factory.createCommunicatorBuilder(configuration);
        return communicatorBuilder.build();
    }

    public static Communicator createCommunicator(URI apiEndpoint, Connection connection, Authenticator authenticator, MetadataProvider metadataProvider) {
        return new DefaultCommunicator(apiEndpoint, connection, authenticator, metadataProvider, DefaultMarshaller.INSTANCE);
    }

    public static ClientInterface createClient(URI configurationFileUri, String apiKeyId, String secretApiKey) {
        Communicator communicator = Factory.createCommunicator(configurationFileUri, apiKeyId, secretApiKey);
        return Factory.createClient(communicator);
    }

    public static ClientInterface createClient(CommunicatorConfiguration configuration) {
        Communicator communicator = Factory.createCommunicator(configuration);
        return Factory.createClient(communicator);
    }

    public static ClientInterface createClient(URI apiEndpoint, Connection connection, Authenticator authenticator, MetadataProvider metadataProvider) {
        Communicator communicator = Factory.createCommunicator(apiEndpoint, connection, authenticator, metadataProvider);
        return Factory.createClient(communicator);
    }

    public static ClientInterface createClient(Communicator communicator) {
        return new Client(communicator);
    }
}

