/*
 * Decompiled with CFR 0.152.
 */
package com.onlinepayments.communication;

import com.onlinepayments.communication.DefaultMetadataProvider;
import com.onlinepayments.communication.MetadataProvider;
import com.onlinepayments.communication.RequestHeader;
import com.onlinepayments.domain.ShoppingCartExtension;
import java.util.ArrayList;
import java.util.List;

public class MetadataProviderBuilder {
    final String integrator;
    ShoppingCartExtension shoppingCartExtension;
    final List<RequestHeader> additionalRequestHeaders = new ArrayList<RequestHeader>();

    public MetadataProviderBuilder(String integrator) {
        if (integrator == null || integrator.trim().isEmpty()) {
            throw new IllegalArgumentException("integrator is required");
        }
        this.integrator = integrator;
    }

    public MetadataProviderBuilder withShoppingCartExtension(ShoppingCartExtension shoppingCartExtension) {
        this.shoppingCartExtension = shoppingCartExtension;
        return this;
    }

    public MetadataProviderBuilder withAdditionalRequestHeader(RequestHeader additionalRequestHeader) {
        DefaultMetadataProvider.validateAdditionalRequestHeader(additionalRequestHeader);
        this.additionalRequestHeaders.add(additionalRequestHeader);
        return this;
    }

    public MetadataProvider build() {
        return new DefaultMetadataProvider(this);
    }
}

