/*
 * Decompiled with CFR 0.152.
 */
package com.onlinepayments.communication;

import com.onlinepayments.communication.ResponseHeader;
import java.util.Collections;
import java.util.List;

public class ResponseException
extends RuntimeException {
    private final int statusCode;
    private final String body;
    private final List<ResponseHeader> headers;

    public ResponseException(int statusCode, String body, List<ResponseHeader> headers) {
        super("the Online Payments platform returned an error response");
        this.statusCode = statusCode;
        this.body = body;
        this.headers = headers != null ? Collections.unmodifiableList(headers) : Collections.emptyList();
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getBody() {
        return this.body;
    }

    public List<ResponseHeader> getHeaders() {
        return this.headers;
    }

    public ResponseHeader getHeader(String headerName) {
        return ResponseHeader.getHeader(this.headers, headerName);
    }

    public String getHeaderValue(String headerName) {
        return ResponseHeader.getHeaderValue(this.headers, headerName);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        if (this.statusCode > 0) {
            sb.append("; statusCode=").append(this.statusCode);
        }
        if (this.body != null && this.body.length() > 0) {
            sb.append("; responseBody='").append(this.body).append("'");
        }
        return sb.toString();
    }
}

