/*
 * Decompiled with CFR 0.152.
 */
package com.onlinepayments.communication;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ResponseHeader {
    private static final Pattern DISPOSITION_FILENAME_PATTERN = Pattern.compile("(?:^|;)\\s*filename\\s*=\\s*(.*?)\\s*(?:;|$)", 2);
    private final String name;
    private final String value;

    public ResponseHeader(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("name is required");
        }
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getName() + ":" + this.getValue();
    }

    public static ResponseHeader getHeader(List<ResponseHeader> headers, String headerName) {
        for (ResponseHeader header : headers) {
            if (!header.getName().equalsIgnoreCase(headerName)) continue;
            return header;
        }
        return null;
    }

    public static String getHeaderValue(List<ResponseHeader> headers, String headerName) {
        ResponseHeader header = ResponseHeader.getHeader(headers, headerName);
        return header != null ? header.getValue() : null;
    }

    public static String getDispositionFilename(List<ResponseHeader> headers) {
        String headerValue = ResponseHeader.getHeaderValue(headers, "Content-Disposition");
        if (headerValue == null) {
            return null;
        }
        Matcher matcher = DISPOSITION_FILENAME_PATTERN.matcher(headerValue);
        if (matcher.find()) {
            String filename = matcher.group(1);
            return ResponseHeader.trimQuotes(filename);
        }
        return null;
    }

    private static String trimQuotes(String filename) {
        if (filename.length() < 2) {
            return filename;
        }
        if (filename.startsWith("\"") && filename.endsWith("\"") || filename.startsWith("'") && filename.endsWith("'")) {
            return filename.substring(1, filename.length() - 1);
        }
        return filename;
    }
}

