/*
 * Decompiled with CFR 0.152.
 */
package com.onlinepayments.logging;

import com.onlinepayments.logging.ObfuscationRule;
import com.onlinepayments.logging.ValueObfuscator;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;

public final class HeaderObfuscator {
    private static final HeaderObfuscator DEFAULT_OBFUSCATOR = HeaderObfuscator.custom().build();
    private final Map<String, ObfuscationRule> obfuscationRules;

    private HeaderObfuscator(Map<String, ObfuscationRule> obfuscationRules) {
        TreeMap<String, ObfuscationRule> copy = new TreeMap<String, ObfuscationRule>(String.CASE_INSENSITIVE_ORDER);
        copy.putAll(obfuscationRules);
        this.obfuscationRules = Collections.unmodifiableMap(copy);
    }

    public String obfuscateHeader(String name, String value) {
        ObfuscationRule obfuscationRule = this.obfuscationRules.get(name);
        return obfuscationRule != null ? obfuscationRule.obfuscateValue(value) : value;
    }

    public static Builder custom() {
        return new Builder().obfuscateWithFixedLength(8, "X-GCS-Authentication-Token").obfuscateWithFixedLength(8, "X-GCS-CallerPassword").obfuscateWithFixedLength(8, "Authorization").obfuscateWithFixedLength(8, "WWW-Authenticate").obfuscateWithFixedLength(8, "Proxy-Authenticate").obfuscateWithFixedLength(8, "Proxy-Authorization");
    }

    public static HeaderObfuscator defaultObfuscator() {
        return DEFAULT_OBFUSCATOR;
    }

    public static final class Builder {
        private final Map<String, ObfuscationRule> obfuscationRules = new LinkedHashMap<String, ObfuscationRule>();

        private Builder() {
        }

        public Builder obfuscateAll(String headerName) {
            this.obfuscationRules.put(headerName, ValueObfuscator.ALL);
            return this;
        }

        public Builder obfuscateWithFixedLength(int fixedLength, String headerName) {
            this.obfuscationRules.put(headerName, ValueObfuscator.fixedLength(fixedLength));
            return this;
        }

        public Builder obfuscateAllButFirst(int count, String headerName) {
            this.obfuscationRules.put(headerName, ValueObfuscator.keepStartCount(count));
            return this;
        }

        public Builder obfuscateAllButLast(int count, String headerName) {
            this.obfuscationRules.put(headerName, ValueObfuscator.keepEndCount(count));
            return this;
        }

        public Builder obfuscateCustom(String headerName, ObfuscationRule obfuscationRule) {
            if (obfuscationRule == null) {
                throw new IllegalArgumentException("obfuscationRule is required");
            }
            this.obfuscationRules.put(headerName, obfuscationRule);
            return this;
        }

        public HeaderObfuscator build() {
            return new HeaderObfuscator(this.obfuscationRules);
        }
    }
}

