/*
 * Decompiled with CFR 0.152.
 */
package com.onlinepayments.logging;

import com.onlinepayments.logging.BodyObfuscator;
import com.onlinepayments.logging.HeaderObfuscator;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;

public abstract class LogMessageBuilder {
    private final String requestId;
    private final StringBuilder headers;
    private String body;
    private String contentType;
    private final BodyObfuscator bodyObfuscator;
    private final HeaderObfuscator headerObfuscator;

    protected LogMessageBuilder(String requestId, BodyObfuscator bodyObfuscator, HeaderObfuscator headerObfuscator) {
        if (requestId == null || requestId.isEmpty()) {
            throw new IllegalArgumentException("requestId is required");
        }
        if (bodyObfuscator == null) {
            throw new IllegalArgumentException("bodyObfuscator is required");
        }
        if (headerObfuscator == null) {
            throw new IllegalArgumentException("headerObfuscator is required");
        }
        this.requestId = requestId;
        this.headers = new StringBuilder();
        this.bodyObfuscator = bodyObfuscator;
        this.headerObfuscator = headerObfuscator;
    }

    protected final String requestId() {
        return this.requestId;
    }

    protected final String headers() {
        return this.headers.toString();
    }

    protected final String body() {
        return this.body;
    }

    protected final String contentType() {
        return this.contentType;
    }

    public final void addHeader(String name, String value) {
        if (this.headers.length() > 0) {
            this.headers.append(", ");
        }
        this.headers.append(name);
        this.headers.append("=\"");
        if (value != null) {
            String obfuscatedValue = this.headerObfuscator.obfuscateHeader(name, value);
            this.headers.append(obfuscatedValue);
        }
        this.headers.append('\"');
    }

    public final void setBody(String body, String contentType) {
        this.body = this.bodyObfuscator.obfuscateBody(body);
        this.contentType = contentType;
    }

    public final void setBody(InputStream bodyStream, Charset charset, String contentType) throws IOException {
        this.body = LogMessageBuilder.isBinaryContent(contentType) ? "<binary content>" : this.bodyObfuscator.obfuscateBody(bodyStream, charset);
        this.contentType = contentType;
    }

    public final void setBinaryContentBody(String contentType) {
        if (!LogMessageBuilder.isBinaryContent(contentType)) {
            throw new IllegalArgumentException("Not a binary content type: " + contentType);
        }
        this.body = "<binary content>";
        this.contentType = contentType;
    }

    private static boolean isBinaryContent(String contentType) {
        return contentType != null && !contentType.startsWith("text/") && !contentType.contains("json") && !contentType.contains("xml");
    }

    public final void setBody(Reader bodyStream, String contentType) throws IOException {
        this.body = this.bodyObfuscator.obfuscateBody(bodyStream);
        this.contentType = contentType;
    }

    public abstract String getMessage();

    protected final String emptyIfNull(String value) {
        return value != null ? value : "";
    }
}

