/*
 * Decompiled with CFR 0.152.
 */
package com.onlinepayments.merchant.captures;

import com.onlinepayments.ApiResource;
import com.onlinepayments.CallContext;
import com.onlinepayments.ExceptionFactory;
import com.onlinepayments.communication.ResponseException;
import com.onlinepayments.domain.CapturesResponse;
import com.onlinepayments.domain.ErrorResponse;
import com.onlinepayments.merchant.captures.CapturesClientInterface;
import java.util.Map;
import java.util.TreeMap;

public class CapturesClient
extends ApiResource
implements CapturesClientInterface {
    private static final ExceptionFactory EXCEPTION_FACTORY = new ExceptionFactory();

    public CapturesClient(ApiResource parent, Map<String, String> pathContext) {
        super(parent, pathContext);
    }

    @Override
    public CapturesResponse getCaptures(String paymentId) {
        return this.getCaptures(paymentId, null);
    }

    @Override
    public CapturesResponse getCaptures(String paymentId, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("paymentId", paymentId);
        String uri = this.instantiateUri("/v2/{merchantId}/payments/{paymentId}/captures", pathContext);
        try {
            return this.communicator.get(uri, this.getClientHeaders(), null, CapturesResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }
}

