/*
 * Decompiled with CFR 0.152.
 */
package com.onlinepayments.merchant.complete;

import com.onlinepayments.ApiResource;
import com.onlinepayments.CallContext;
import com.onlinepayments.ExceptionFactory;
import com.onlinepayments.communication.ResponseException;
import com.onlinepayments.domain.CompletePaymentRequest;
import com.onlinepayments.domain.CompletePaymentResponse;
import com.onlinepayments.domain.PaymentErrorResponse;
import com.onlinepayments.merchant.complete.CompleteClientInterface;
import java.util.Map;
import java.util.TreeMap;

public class CompleteClient
extends ApiResource
implements CompleteClientInterface {
    private static final ExceptionFactory EXCEPTION_FACTORY = new ExceptionFactory();

    public CompleteClient(ApiResource parent, Map<String, String> pathContext) {
        super(parent, pathContext);
    }

    @Override
    public CompletePaymentResponse completePayment(String paymentId, CompletePaymentRequest body) {
        return this.completePayment(paymentId, body, null);
    }

    @Override
    public CompletePaymentResponse completePayment(String paymentId, CompletePaymentRequest body, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("paymentId", paymentId);
        String uri = this.instantiateUri("/v2/{merchantId}/payments/{paymentId}/complete", pathContext);
        try {
            return this.communicator.post(uri, this.getClientHeaders(), null, (Object)body, CompletePaymentResponse.class, context);
        }
        catch (ResponseException e) {
            Class<PaymentErrorResponse> errorType = PaymentErrorResponse.class;
            PaymentErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }
}

