/*
 * Decompiled with CFR 0.152.
 */
package com.onlinepayments.merchant.payments;

import com.onlinepayments.ApiResource;
import com.onlinepayments.CallContext;
import com.onlinepayments.ExceptionFactory;
import com.onlinepayments.communication.ResponseException;
import com.onlinepayments.domain.CancelPaymentRequest;
import com.onlinepayments.domain.CancelPaymentResponse;
import com.onlinepayments.domain.CapturePaymentRequest;
import com.onlinepayments.domain.CaptureResponse;
import com.onlinepayments.domain.CreatePaymentRequest;
import com.onlinepayments.domain.CreatePaymentResponse;
import com.onlinepayments.domain.ErrorResponse;
import com.onlinepayments.domain.PaymentDetailsResponse;
import com.onlinepayments.domain.PaymentErrorResponse;
import com.onlinepayments.domain.PaymentResponse;
import com.onlinepayments.domain.RefundErrorResponse;
import com.onlinepayments.domain.RefundRequest;
import com.onlinepayments.domain.RefundResponse;
import com.onlinepayments.domain.SubsequentPaymentRequest;
import com.onlinepayments.domain.SubsequentPaymentResponse;
import com.onlinepayments.merchant.payments.PaymentsClientInterface;
import java.util.Map;
import java.util.TreeMap;

public class PaymentsClient
extends ApiResource
implements PaymentsClientInterface {
    private static final ExceptionFactory EXCEPTION_FACTORY = new ExceptionFactory();

    public PaymentsClient(ApiResource parent, Map<String, String> pathContext) {
        super(parent, pathContext);
    }

    @Override
    public CreatePaymentResponse createPayment(CreatePaymentRequest body) {
        return this.createPayment(body, null);
    }

    @Override
    public CreatePaymentResponse createPayment(CreatePaymentRequest body, CallContext context) {
        String uri = this.instantiateUri("/v2/{merchantId}/payments", null);
        try {
            return this.communicator.post(uri, this.getClientHeaders(), null, (Object)body, CreatePaymentResponse.class, context);
        }
        catch (ResponseException e) {
            Class<PaymentErrorResponse> errorType = PaymentErrorResponse.class;
            PaymentErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    @Override
    public PaymentResponse getPayment(String paymentId) {
        return this.getPayment(paymentId, null);
    }

    @Override
    public PaymentResponse getPayment(String paymentId, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("paymentId", paymentId);
        String uri = this.instantiateUri("/v2/{merchantId}/payments/{paymentId}", pathContext);
        try {
            return this.communicator.get(uri, this.getClientHeaders(), null, PaymentResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    @Override
    public PaymentDetailsResponse getPaymentDetails(String paymentId) {
        return this.getPaymentDetails(paymentId, null);
    }

    @Override
    public PaymentDetailsResponse getPaymentDetails(String paymentId, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("paymentId", paymentId);
        String uri = this.instantiateUri("/v2/{merchantId}/payments/{paymentId}/details", pathContext);
        try {
            return this.communicator.get(uri, this.getClientHeaders(), null, PaymentDetailsResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    @Override
    public CancelPaymentResponse cancelPayment(String paymentId, CancelPaymentRequest body) {
        return this.cancelPayment(paymentId, body, null);
    }

    @Override
    public CancelPaymentResponse cancelPayment(String paymentId, CancelPaymentRequest body, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("paymentId", paymentId);
        String uri = this.instantiateUri("/v2/{merchantId}/payments/{paymentId}/cancel", pathContext);
        try {
            return this.communicator.post(uri, this.getClientHeaders(), null, (Object)body, CancelPaymentResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    @Override
    public CaptureResponse capturePayment(String paymentId, CapturePaymentRequest body) {
        return this.capturePayment(paymentId, body, null);
    }

    @Override
    public CaptureResponse capturePayment(String paymentId, CapturePaymentRequest body, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("paymentId", paymentId);
        String uri = this.instantiateUri("/v2/{merchantId}/payments/{paymentId}/capture", pathContext);
        try {
            return this.communicator.post(uri, this.getClientHeaders(), null, (Object)body, CaptureResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    @Override
    public RefundResponse refundPayment(String paymentId, RefundRequest body) {
        return this.refundPayment(paymentId, body, null);
    }

    @Override
    public RefundResponse refundPayment(String paymentId, RefundRequest body, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("paymentId", paymentId);
        String uri = this.instantiateUri("/v2/{merchantId}/payments/{paymentId}/refund", pathContext);
        try {
            return this.communicator.post(uri, this.getClientHeaders(), null, (Object)body, RefundResponse.class, context);
        }
        catch (ResponseException e) {
            Class<RefundErrorResponse> errorType = RefundErrorResponse.class;
            RefundErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    @Override
    public SubsequentPaymentResponse subsequentPayment(String paymentId, SubsequentPaymentRequest body) {
        return this.subsequentPayment(paymentId, body, null);
    }

    @Override
    public SubsequentPaymentResponse subsequentPayment(String paymentId, SubsequentPaymentRequest body, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("paymentId", paymentId);
        String uri = this.instantiateUri("/v2/{merchantId}/payments/{paymentId}/subsequent", pathContext);
        try {
            return this.communicator.post(uri, this.getClientHeaders(), null, (Object)body, SubsequentPaymentResponse.class, context);
        }
        catch (ResponseException e) {
            Class<PaymentErrorResponse> errorType = PaymentErrorResponse.class;
            PaymentErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }
}

