/*
 * Decompiled with CFR 0.152.
 */
package com.onlinepayments.merchant.productgroups;

import com.onlinepayments.ApiResource;
import com.onlinepayments.CallContext;
import com.onlinepayments.ExceptionFactory;
import com.onlinepayments.communication.ParamRequest;
import com.onlinepayments.communication.ResponseException;
import com.onlinepayments.domain.ErrorResponse;
import com.onlinepayments.domain.GetPaymentProductGroupsResponse;
import com.onlinepayments.domain.PaymentProductGroup;
import com.onlinepayments.merchant.productgroups.GetProductGroupParams;
import com.onlinepayments.merchant.productgroups.GetProductGroupsParams;
import com.onlinepayments.merchant.productgroups.ProductGroupsClientInterface;
import java.util.Map;
import java.util.TreeMap;

public class ProductGroupsClient
extends ApiResource
implements ProductGroupsClientInterface {
    private static final ExceptionFactory EXCEPTION_FACTORY = new ExceptionFactory();

    public ProductGroupsClient(ApiResource parent, Map<String, String> pathContext) {
        super(parent, pathContext);
    }

    @Override
    public GetPaymentProductGroupsResponse getProductGroups(GetProductGroupsParams query) {
        return this.getProductGroups(query, null);
    }

    @Override
    public GetPaymentProductGroupsResponse getProductGroups(GetProductGroupsParams query, CallContext context) {
        String uri = this.instantiateUri("/v2/{merchantId}/productgroups", null);
        try {
            return this.communicator.get(uri, this.getClientHeaders(), (ParamRequest)query, GetPaymentProductGroupsResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    @Override
    public PaymentProductGroup getProductGroup(String paymentProductGroupId, GetProductGroupParams query) {
        return this.getProductGroup(paymentProductGroupId, query, null);
    }

    @Override
    public PaymentProductGroup getProductGroup(String paymentProductGroupId, GetProductGroupParams query, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("paymentProductGroupId", paymentProductGroupId);
        String uri = this.instantiateUri("/v2/{merchantId}/productgroups/{paymentProductGroupId}", pathContext);
        try {
            return this.communicator.get(uri, this.getClientHeaders(), (ParamRequest)query, PaymentProductGroup.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }
}

