/*
 * Decompiled with CFR 0.152.
 */
package com.onlinepayments.merchant.products;

import com.onlinepayments.ApiResource;
import com.onlinepayments.CallContext;
import com.onlinepayments.ExceptionFactory;
import com.onlinepayments.communication.ParamRequest;
import com.onlinepayments.communication.ResponseException;
import com.onlinepayments.domain.ErrorResponse;
import com.onlinepayments.domain.GetPaymentProductsResponse;
import com.onlinepayments.domain.PaymentProduct;
import com.onlinepayments.domain.PaymentProductNetworksResponse;
import com.onlinepayments.domain.ProductDirectory;
import com.onlinepayments.merchant.products.GetPaymentProductNetworksParams;
import com.onlinepayments.merchant.products.GetPaymentProductParams;
import com.onlinepayments.merchant.products.GetPaymentProductsParams;
import com.onlinepayments.merchant.products.GetProductDirectoryParams;
import com.onlinepayments.merchant.products.ProductsClientInterface;
import java.util.Map;
import java.util.TreeMap;

public class ProductsClient
extends ApiResource
implements ProductsClientInterface {
    private static final ExceptionFactory EXCEPTION_FACTORY = new ExceptionFactory();

    public ProductsClient(ApiResource parent, Map<String, String> pathContext) {
        super(parent, pathContext);
    }

    @Override
    public GetPaymentProductsResponse getPaymentProducts(GetPaymentProductsParams query) {
        return this.getPaymentProducts(query, null);
    }

    @Override
    public GetPaymentProductsResponse getPaymentProducts(GetPaymentProductsParams query, CallContext context) {
        String uri = this.instantiateUri("/v2/{merchantId}/products", null);
        try {
            return this.communicator.get(uri, this.getClientHeaders(), (ParamRequest)query, GetPaymentProductsResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    @Override
    public PaymentProduct getPaymentProduct(Integer paymentProductId, GetPaymentProductParams query) {
        return this.getPaymentProduct(paymentProductId, query, null);
    }

    @Override
    public PaymentProduct getPaymentProduct(Integer paymentProductId, GetPaymentProductParams query, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("paymentProductId", paymentProductId.toString());
        String uri = this.instantiateUri("/v2/{merchantId}/products/{paymentProductId}", pathContext);
        try {
            return this.communicator.get(uri, this.getClientHeaders(), (ParamRequest)query, PaymentProduct.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    @Override
    public PaymentProductNetworksResponse getPaymentProductNetworks(Integer paymentProductId, GetPaymentProductNetworksParams query) {
        return this.getPaymentProductNetworks(paymentProductId, query, null);
    }

    @Override
    public PaymentProductNetworksResponse getPaymentProductNetworks(Integer paymentProductId, GetPaymentProductNetworksParams query, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("paymentProductId", paymentProductId.toString());
        String uri = this.instantiateUri("/v2/{merchantId}/products/{paymentProductId}/networks", pathContext);
        try {
            return this.communicator.get(uri, this.getClientHeaders(), (ParamRequest)query, PaymentProductNetworksResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    @Override
    public ProductDirectory getProductDirectory(Integer paymentProductId, GetProductDirectoryParams query) {
        return this.getProductDirectory(paymentProductId, query, null);
    }

    @Override
    public ProductDirectory getProductDirectory(Integer paymentProductId, GetProductDirectoryParams query, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("paymentProductId", paymentProductId.toString());
        String uri = this.instantiateUri("/v2/{merchantId}/products/{paymentProductId}/directory", pathContext);
        try {
            return this.communicator.get(uri, this.getClientHeaders(), (ParamRequest)query, ProductDirectory.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }
}

