/*
 * Decompiled with CFR 0.152.
 */
package com.onlinepayments.merchant.refunds;

import com.onlinepayments.ApiResource;
import com.onlinepayments.CallContext;
import com.onlinepayments.ExceptionFactory;
import com.onlinepayments.communication.ResponseException;
import com.onlinepayments.domain.ErrorResponse;
import com.onlinepayments.domain.RefundsResponse;
import com.onlinepayments.merchant.refunds.RefundsClientInterface;
import java.util.Map;
import java.util.TreeMap;

public class RefundsClient
extends ApiResource
implements RefundsClientInterface {
    private static final ExceptionFactory EXCEPTION_FACTORY = new ExceptionFactory();

    public RefundsClient(ApiResource parent, Map<String, String> pathContext) {
        super(parent, pathContext);
    }

    @Override
    public RefundsResponse getRefunds(String paymentId) {
        return this.getRefunds(paymentId, null);
    }

    @Override
    public RefundsResponse getRefunds(String paymentId, CallContext context) {
        TreeMap<String, String> pathContext = new TreeMap<String, String>();
        pathContext.put("paymentId", paymentId);
        String uri = this.instantiateUri("/v2/{merchantId}/payments/{paymentId}/refunds", pathContext);
        try {
            return this.communicator.get(uri, this.getClientHeaders(), null, RefundsResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }
}

