/*
 * Decompiled with CFR 0.152.
 */
package com.onlinepayments.merchant.services;

import com.onlinepayments.ApiResource;
import com.onlinepayments.CallContext;
import com.onlinepayments.ExceptionFactory;
import com.onlinepayments.communication.ResponseException;
import com.onlinepayments.domain.CalculateSurchargeRequest;
import com.onlinepayments.domain.CalculateSurchargeResponse;
import com.onlinepayments.domain.CurrencyConversionRequest;
import com.onlinepayments.domain.CurrencyConversionResponse;
import com.onlinepayments.domain.ErrorResponse;
import com.onlinepayments.domain.GetIINDetailsRequest;
import com.onlinepayments.domain.GetIINDetailsResponse;
import com.onlinepayments.domain.TestConnection;
import com.onlinepayments.merchant.services.ServicesClientInterface;
import java.util.Map;

public class ServicesClient
extends ApiResource
implements ServicesClientInterface {
    private static final ExceptionFactory EXCEPTION_FACTORY = new ExceptionFactory();

    public ServicesClient(ApiResource parent, Map<String, String> pathContext) {
        super(parent, pathContext);
    }

    @Override
    public TestConnection testConnection() {
        return this.testConnection(null);
    }

    @Override
    public TestConnection testConnection(CallContext context) {
        String uri = this.instantiateUri("/v2/{merchantId}/services/testconnection", null);
        try {
            return this.communicator.get(uri, this.getClientHeaders(), null, TestConnection.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    @Override
    public GetIINDetailsResponse getIINDetails(GetIINDetailsRequest body) {
        return this.getIINDetails(body, null);
    }

    @Override
    public GetIINDetailsResponse getIINDetails(GetIINDetailsRequest body, CallContext context) {
        String uri = this.instantiateUri("/v2/{merchantId}/services/getIINdetails", null);
        try {
            return this.communicator.post(uri, this.getClientHeaders(), null, (Object)body, GetIINDetailsResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    @Override
    public CurrencyConversionResponse getDccRateInquiry(CurrencyConversionRequest body) {
        return this.getDccRateInquiry(body, null);
    }

    @Override
    public CurrencyConversionResponse getDccRateInquiry(CurrencyConversionRequest body, CallContext context) {
        String uri = this.instantiateUri("/v2/{merchantId}/services/dccrate", null);
        try {
            return this.communicator.post(uri, this.getClientHeaders(), null, (Object)body, CurrencyConversionResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    @Override
    public CalculateSurchargeResponse surchargeCalculation(CalculateSurchargeRequest body) {
        return this.surchargeCalculation(body, null);
    }

    @Override
    public CalculateSurchargeResponse surchargeCalculation(CalculateSurchargeRequest body, CallContext context) {
        String uri = this.instantiateUri("/v2/{merchantId}/services/surchargecalculation", null);
        try {
            return this.communicator.post(uri, this.getClientHeaders(), null, (Object)body, CalculateSurchargeResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }
}

