/*
 * Decompiled with CFR 0.152.
 */
package com.onlinepayments.merchant.webhooks;

import com.onlinepayments.ApiResource;
import com.onlinepayments.CallContext;
import com.onlinepayments.ExceptionFactory;
import com.onlinepayments.communication.ResponseException;
import com.onlinepayments.domain.ErrorResponse;
import com.onlinepayments.domain.SendTestRequest;
import com.onlinepayments.domain.ValidateCredentialsRequest;
import com.onlinepayments.domain.ValidateCredentialsResponse;
import com.onlinepayments.merchant.webhooks.WebhooksClientInterface;
import java.util.Map;

public class WebhooksClient
extends ApiResource
implements WebhooksClientInterface {
    private static final ExceptionFactory EXCEPTION_FACTORY = new ExceptionFactory();

    public WebhooksClient(ApiResource parent, Map<String, String> pathContext) {
        super(parent, pathContext);
    }

    @Override
    public ValidateCredentialsResponse validateWebhookCredentials(ValidateCredentialsRequest body) {
        return this.validateWebhookCredentials(body, null);
    }

    @Override
    public ValidateCredentialsResponse validateWebhookCredentials(ValidateCredentialsRequest body, CallContext context) {
        String uri = this.instantiateUri("/v2/{merchantId}/webhooks/validateCredentials", null);
        try {
            return this.communicator.post(uri, this.getClientHeaders(), null, (Object)body, ValidateCredentialsResponse.class, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }

    @Override
    public void sendTestWebhook(SendTestRequest body) {
        this.sendTestWebhook(body, null);
    }

    @Override
    public void sendTestWebhook(SendTestRequest body, CallContext context) {
        String uri = this.instantiateUri("/v2/{merchantId}/webhooks/sendtest", null);
        try {
            this.communicator.post(uri, this.getClientHeaders(), null, (Object)body, Void.TYPE, context);
        }
        catch (ResponseException e) {
            Class<ErrorResponse> errorType = ErrorResponse.class;
            ErrorResponse errorObject = this.communicator.getMarshaller().unmarshal(e.getBody(), errorType);
            throw EXCEPTION_FACTORY.createException(e.getStatusCode(), e.getBody(), errorObject, context);
        }
    }
}

