/*
 * Decompiled with CFR 0.152.
 */
package com.worldline.sips.helper;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.YearMonthDeserializer;
import com.worldline.sips.model.ResponseData;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ResponseDataDeserializer
extends JsonDeserializer<ResponseData> {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public ResponseData deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (jsonParser.getText() == null) {
            return null;
        }
        String value = jsonParser.getText().trim();
        Map<String, String> mapped = Arrays.stream(value.split("\\|")).map(element -> element.split("=", 2)).filter(pair -> this.isNotNullOrEmpty(pair[1])).collect(Collectors.toMap(pair -> pair[0], pair -> pair[1]));
        return (ResponseData)this.objectMapper.registerModule((Module)new JavaTimeModule().addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(DateTimeFormatter.ISO_OFFSET_DATE_TIME)).addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer(DateTimeFormatter.BASIC_ISO_DATE)).addDeserializer(YearMonth.class, (JsonDeserializer)new YearMonthDeserializer(DateTimeFormatter.ofPattern("yyyyMM")))).convertValue(mapped, ResponseData.class);
    }

    private boolean isNotNullOrEmpty(CharSequence cs) {
        return !StringUtils.isBlank((CharSequence)cs) && !StringUtils.equals((CharSequence)cs, (CharSequence)"null");
    }
}

