/*
 * Decompiled with CFR 0.152.
 */
package com.worldline.sips.util;

import com.worldline.sips.exception.SealCalculationException;
import com.worldline.sips.helper.AlphabeticalReflectionToStringBuilder;
import com.worldline.sips.helper.SealStringStyle;
import com.worldline.sips.model.InitializationResponse;
import com.worldline.sips.model.PaymentRequest;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.builder.ToStringStyle;

public class SealCalculator {
    private SealCalculator() {
    }

    public static String calculate(String sealString, String key) throws SealCalculationException {
        try {
            Mac hmacSHA256 = Mac.getInstance("HmacSHA256");
            SecretKeySpec secretKeySpec = new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), "HmacSHA256");
            hmacSHA256.init(secretKeySpec);
            return Hex.encodeHexString((byte[])hmacSHA256.doFinal(sealString.getBytes(StandardCharsets.UTF_8)));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new SealCalculationException("Seal could not be calculated!", e);
        }
    }

    public static String getSealString(PaymentRequest paymentRequest) {
        AlphabeticalReflectionToStringBuilder reflectionToStringBuilder = new AlphabeticalReflectionToStringBuilder(paymentRequest, (ToStringStyle)new SealStringStyle());
        reflectionToStringBuilder.setExcludeFieldNames(new String[]{"keyVersion"});
        reflectionToStringBuilder.setExcludeNullValues(true);
        reflectionToStringBuilder.setAppendStatics(true);
        return reflectionToStringBuilder.toString();
    }

    public static String getSealString(InitializationResponse initializationResponse) {
        AlphabeticalReflectionToStringBuilder reflectionToStringBuilder = new AlphabeticalReflectionToStringBuilder(initializationResponse, (ToStringStyle)new SealStringStyle());
        reflectionToStringBuilder.setExcludeFieldNames(new String[]{"seal"});
        reflectionToStringBuilder.setExcludeNullValues(true);
        return reflectionToStringBuilder.toString();
    }
}

