/*
 * Decompiled with CFR 0.152.
 */
package com.worldline.sips.api;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.worldline.sips.api.configuration.Environment;
import com.worldline.sips.api.exception.IncorrectProxyConfException;
import com.worldline.sips.api.exception.IncorrectSealException;
import com.worldline.sips.api.exception.InvalidEnvironmentException;
import com.worldline.sips.api.exception.InvalidKeyException;
import com.worldline.sips.api.exception.InvalidMerchantException;
import com.worldline.sips.api.exception.PaymentInitializationException;
import com.worldline.sips.exception.SealCalculationException;
import com.worldline.sips.model.InitializationResponse;
import com.worldline.sips.model.PaymentRequest;
import com.worldline.sips.model.PaypageResponse;
import com.worldline.sips.util.SealCalculator;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

public class PaypageClient {
    private Environment environment;
    private Integer keyVersion;
    private String merchantId;
    private String secretKey;
    private String proxyHost;
    private Integer proxyPort;
    private boolean proxyEnabled;

    public PaypageClient(Environment environment, String merchantId, Integer keyVersion, String secretKey) throws InvalidEnvironmentException, IncorrectProxyConfException, InvalidKeyException, InvalidMerchantException {
        this(environment, merchantId, keyVersion, secretKey, false, null, null);
    }

    public PaypageClient(Environment environment, String merchantId, Integer keyVersion, String secretKey, boolean proxyEnabled, String proxyHost, Integer proxyPort) throws InvalidEnvironmentException, InvalidMerchantException, InvalidKeyException, IncorrectProxyConfException {
        if (environment == null) {
            throw new InvalidEnvironmentException("Invalid environment specified!");
        }
        if (StringUtils.isBlank((CharSequence)merchantId)) {
            throw new InvalidMerchantException("Invalid merchant ID specified!");
        }
        if (keyVersion == null) {
            throw new InvalidKeyException("Invalid key version specified!");
        }
        if (StringUtils.isBlank((CharSequence)secretKey)) {
            throw new InvalidKeyException("Invalid key specified!");
        }
        if (proxyEnabled && (StringUtils.isBlank((CharSequence)proxyHost) || proxyPort == null)) {
            throw new IncorrectProxyConfException("ProxyEnabled is true but proxyHost or proxyPort not filled");
        }
        this.environment = environment;
        this.keyVersion = keyVersion;
        this.merchantId = merchantId;
        this.secretKey = secretKey;
        this.proxyEnabled = proxyEnabled;
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
    }

    public InitializationResponse initialize(PaymentRequest paymentRequest) throws IncorrectSealException, PaymentInitializationException, SealCalculationException {
        try {
            HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
            if (this.proxyEnabled) {
                HttpHost httpHost = new HttpHost(this.proxyHost, this.proxyPort.intValue());
                httpClientBuilder.setProxy(httpHost);
            }
            CloseableHttpClient httpClient = httpClientBuilder.build();
            paymentRequest.setMerchantId(this.merchantId);
            paymentRequest.setKeyVersion(this.keyVersion);
            paymentRequest.setSeal(SealCalculator.calculate((String)SealCalculator.getSealString((PaymentRequest)paymentRequest), (String)this.secretKey));
            StringEntity requestEntity = new StringEntity(new ObjectMapper().writeValueAsString((Object)paymentRequest), ContentType.APPLICATION_JSON);
            HttpPost postMethod = new HttpPost(this.getEnvironmentUrl());
            postMethod.setEntity((HttpEntity)requestEntity);
            CloseableHttpResponse rawResponse = httpClient.execute((HttpUriRequest)postMethod);
            InitializationResponse initializationResponse = (InitializationResponse)new ObjectMapper().readValue(EntityUtils.toString((HttpEntity)rawResponse.getEntity()), InitializationResponse.class);
            this.verifySeal(initializationResponse);
            return initializationResponse;
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new PaymentInitializationException("Exception while parsing PaymentRequest!", e);
        }
        catch (IOException e) {
            throw new PaymentInitializationException("Exception while processing response from server!", e);
        }
    }

    public PaypageResponse decodeResponse(Map<String, String> parameters) throws IncorrectSealException {
        this.verifySeal(parameters.get("Data"), parameters.get("Seal"));
        return (PaypageResponse)new ObjectMapper().convertValue(parameters, PaypageResponse.class);
    }

    private URI getEnvironmentUrl() {
        return URI.create(this.environment.getUrl());
    }

    private void verifySeal(InitializationResponse initializationResponse) throws IncorrectSealException, SealCalculationException {
        String correctSeal;
        if (initializationResponse.getSeal() != null && !StringUtils.equals((CharSequence)(correctSeal = SealCalculator.calculate((String)SealCalculator.getSealString((InitializationResponse)initializationResponse), (String)this.secretKey)), (CharSequence)initializationResponse.getSeal())) {
            throw new IncorrectSealException("The initialization response has been tampered with!");
        }
    }

    private void verifySeal(String data, String seal) throws IncorrectSealException {
        String correctSeal = DigestUtils.sha256Hex((String)(data + this.secretKey));
        if (!StringUtils.equals((CharSequence)correctSeal, (CharSequence)seal)) {
            throw new IncorrectSealException("The payment page response has been tampered with!");
        }
    }
}

