/*
 * Decompiled with CFR 0.152.
 */
package com.worldpay.cse;

import com.worldpay.cse.WPCardData;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

class WPCardValidator {
    private static final String EX_MONTH_PATTERN = "^[0-9]{2}$";
    private static final String EX_YEAR_PATTERN = "^[0-9]{4}$";
    private static final String CARD_NUMBER_PATTERN = "[0-9]{12,20}";
    private static final String CARD_HOLDER_PATTERN = "^.{1,30}$";
    private static final String CVC_PATTERN = "^[0-9]{3,4}$";
    private static final int MAX_SINGLE_DIGIT_NUMBER = 9;
    private static final int DIVIDER_VALUE = 10;
    private static final int AMPLIFIER_VALUE = 2;
    private static final int INVALID_MONTH = 300;
    private static final int INVALID_MONTH_2 = 303;
    private static final int INVALID_YEAR = 303;
    private static final int INVALID_DATE = 306;
    private static final int INVALID_CARD_HOLDER_NAME = 400;
    private static final int INVALID_CVC = 201;
    private static final int INVALID_CARD_NUMBER = 100;
    private static final int INVALID_LUHN = 103;
    private static final int MIN_MONTH = 1;
    private static final int MAX_MONTH = 12;
    private static final int EMPTY_VALUE = 1;
    private static final int INVALID_VALUE = 2;
    private static final int NO_ERROR = 0;

    WPCardValidator() {
    }

    public Set<Integer> validateCardData(WPCardData cardData) {
        HashSet<Integer> errorsCodes = new HashSet<Integer>();
        this.checkErrorCode(this.validateCardNumber(cardData.getCardNumber()), errorsCodes);
        this.checkErrorCode(this.validateCvc(cardData.getCvc()), errorsCodes);
        this.checkErrorCode(this.validateMonth(cardData.getExpiryMonth()), errorsCodes);
        this.checkErrorCode(this.validateYear(cardData.getExpiryYear()), errorsCodes);
        this.checkErrorCode(this.validateDate(cardData.getExpiryMonth(), cardData.getExpiryYear()), errorsCodes);
        this.checkErrorCode(this.validateCardHolderName(cardData.getCardHolderName()), errorsCodes);
        return errorsCodes;
    }

    private int validateMonth(String expiryMonth) {
        int validNumber = this.validateValue(expiryMonth, EX_MONTH_PATTERN);
        if (validNumber != 0) {
            return 300 + validNumber;
        }
        int exMonth = Integer.parseInt(expiryMonth);
        if (exMonth < 1 || exMonth > 12) {
            return 303;
        }
        return 0;
    }

    private int validateYear(String expiryYear) {
        int validNumber = this.validateValue(expiryYear, EX_YEAR_PATTERN);
        if (validNumber != 0) {
            return 303 + validNumber;
        }
        return 0;
    }

    private int validateDate(String expiryMonth, String expiryYear) {
        int exYear;
        int exMonth;
        if (this.validateMonth(expiryMonth) == 0 && this.validateYear(expiryYear) == 0 && !this.isFutureDate(exMonth = Integer.parseInt(expiryMonth), exYear = Integer.parseInt(expiryYear))) {
            return 306;
        }
        return 0;
    }

    private int validateValue(String value, String pattern) {
        if (this.isEmpty(value) || this.isEmpty(value.trim())) {
            return 1;
        }
        if (!this.evaluateRegex(value, pattern)) {
            return 2;
        }
        return 0;
    }

    private boolean isFutureDate(int expiryMonth, int expiryYear) {
        Calendar now = Calendar.getInstance();
        int currentMonth = now.get(2);
        int currentYear = now.get(1);
        return expiryYear * 12 + (expiryMonth - 1) >= currentYear * 12 + currentMonth;
    }

    private int validateCardHolderName(String cardHolderName) {
        int valid = this.validateValue(cardHolderName, CARD_HOLDER_PATTERN);
        if (valid != 0) {
            return 400 + valid;
        }
        return 0;
    }

    private int validateCvc(String cvc) {
        if (this.isEmpty(cvc) || this.evaluateRegex(cvc, CVC_PATTERN)) {
            return 0;
        }
        return 201;
    }

    private int validateCardNumber(String cardNumber) {
        int valid = this.validateValue(cardNumber, CARD_NUMBER_PATTERN);
        if (valid != 0) {
            return 100 + valid;
        }
        if (!this.validateLuhn(cardNumber)) {
            return 103;
        }
        return 0;
    }

    public boolean validateLuhn(String value) {
        int nCheck = 0;
        boolean alternate = false;
        for (int i = value.length() - 1; i >= 0; --i) {
            int nDigit = Integer.parseInt(String.valueOf(value.charAt(i)));
            if (alternate && (nDigit *= 2) > 9) {
                nDigit -= 9;
            }
            nCheck += nDigit;
            alternate = !alternate;
        }
        return nCheck % 10 == 0;
    }

    private boolean checkErrorCode(int errorCode, Set<Integer> errorsCodes) {
        if (errorCode != 0) {
            errorsCodes.add(errorCode);
            return false;
        }
        return true;
    }

    private boolean evaluateRegex(String data, String re) {
        return Pattern.matches(re, data);
    }

    private boolean isEmpty(String data) {
        return data == null || "".equals(data) || this.evaluateRegex(data, "!/[^\\s]/");
    }
}

