/*
 * Decompiled with CFR 0.152.
 */
package com.worldpay.cse;

import com.worldpay.cse.exception.WPCSEInvalidPublicKey;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;

public class WPPublicKey {
    private static final String EMPTY = "";
    private static final int HEXADECIMAL = 16;
    private static final String HASH = "#";
    private RSAPublicKey key = null;
    private String keySeqNo = null;

    public static WPPublicKey parseKey(String plainKey) throws WPCSEInvalidPublicKey {
        try {
            String[] components = plainKey.split(HASH);
            if (components.length < 3) {
                throw new WPCSEInvalidPublicKey();
            }
            String exponent = components[1];
            String modulus = components[2];
            RSAPublicKeySpec keySpec = new RSAPublicKeySpec(new BigInteger(modulus, 16), new BigInteger(exponent, 16));
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            RSAPublicKey key = (RSAPublicKey)keyFactory.generatePublic(keySpec);
            String keySeqNo = components[0];
            if (EMPTY.equals(keySeqNo)) {
                throw new WPCSEInvalidPublicKey();
            }
            return new WPPublicKey(key, keySeqNo);
        }
        catch (NumberFormatException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new WPCSEInvalidPublicKey(e);
        }
    }

    public WPPublicKey(RSAPublicKey key, String keySeqNo) {
        this.key = key;
        this.keySeqNo = keySeqNo;
    }

    public RSAPublicKey getKey() {
        return this.key;
    }

    public String getKeySeqNo() {
        return this.keySeqNo;
    }

    public String toString() {
        return this.keySeqNo + HASH + this.key.getPublicExponent().toString(16) + HASH + this.key.getModulus().toString(16);
    }
}

