/*
 * Decompiled with CFR 0.152.
 */
package com.worldpay.cse;

import com.worldpay.cse.WPCardData;
import com.worldpay.cse.WPCardValidator;
import com.worldpay.cse.WPPublicKey;
import com.worldpay.cse.exception.WPCSEException;
import com.worldpay.cse.exception.WPCSEInvalidCardData;
import com.worldpay.cse.exception.WPCSEInvalidPublicKey;
import com.worldpay.cse.jwe.WPJWEHeader;
import com.worldpay.cse.jwe.WPJWEObject;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WorldpayCSE {
    public static final String RSA_1_5 = "RSA1_5";
    public static final String A_256_GCM = "A256GCM";
    public static final String API_VERSION = "1.0";
    public static final String LIB_VERSION = "1.0.4";
    public static final String CHANNEL = "android";
    private static final Logger LOGGER = Logger.getAnonymousLogger();
    private WPPublicKey publicKey;

    public void setPublicKey(String publicKey) throws WPCSEInvalidPublicKey {
        this.publicKey = WPPublicKey.parseKey(publicKey);
    }

    public WPPublicKey getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(WPPublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public static boolean isValidPublicKey(String stringKey) {
        try {
            WPPublicKey.parseKey(stringKey);
        }
        catch (WPCSEInvalidPublicKey e) {
            LOGGER.log(Level.INFO, e.getMessage(), e);
            return false;
        }
        return true;
    }

    public String encrypt(WPCardData cardData) throws WPCSEException {
        Set<Integer> errors = new WPCardValidator().validateCardData(cardData);
        if (errors.isEmpty()) {
            if (this.publicKey != null) {
                return this.performEncryption(cardData.toString());
            }
            throw new WPCSEException("Public key not set");
        }
        throw new WPCSEInvalidCardData(errors);
    }

    public static Set<Integer> validate(WPCardData data) {
        return new WPCardValidator().validateCardData(data);
    }

    private String performEncryption(String data) {
        WPJWEHeader header = new WPJWEHeader();
        header.setAlgorithm(RSA_1_5);
        header.setEncryption(A_256_GCM);
        header.setKid(this.publicKey.getKeySeqNo());
        header.setApiVersion(API_VERSION);
        header.setLibVersion(LIB_VERSION);
        header.setChannel(CHANNEL);
        WPJWEObject jweObject = new WPJWEObject(header, data);
        jweObject.setKey(this.publicKey.getKey());
        jweObject.encrypt();
        return jweObject.serialize();
    }
}

